/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.security.xml.helper;

import com.sdl.delivery.security.xml.SecureXmlProcessingUtils;
import com.sdl.delivery.security.xml.XmlEqualsResult;
import com.sdl.delivery.security.xml.XmlRestriction;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class XmlEqualityChecker {
    private static volatile Logger logger = null;
    private static final DocumentBuilderFactory BUILDER_FACTORY = SecureXmlProcessingUtils.createDocumentBuilderFactory(XmlRestriction.makeForLocalFiles());
    private static final TransformerFactory TRANSFORMER_FACTORY = SecureXmlProcessingUtils.createTransformerFactory(XmlRestriction.makeForLocalFiles());

    public XmlEqualsResult xmlEquals(String expectedXml, String actualXml) throws Exception {
        DocumentBuilder builder = BUILDER_FACTORY.newDocumentBuilder();
        Document expected = builder.parse(new ByteArrayInputStream(expectedXml.getBytes(StandardCharsets.UTF_8)));
        expected.normalizeDocument();
        Document actual = builder.parse(new ByteArrayInputStream(actualXml.getBytes(StandardCharsets.UTF_8)));
        actual.normalizeDocument();
        XmlEqualsResult xmlEqualsResult = new XmlEqualsResult(this.xmlToString(expected), this.xmlToString(actual));
        if (!xmlEqualsResult.isEquals() && logger != null) {
            logger.warn("XML are not equals: \n'expected: {}'\nbut was\n'actual:  '{}'", (Object)xmlEqualsResult.getExpected(), (Object)xmlEqualsResult.getActual());
        }
        return xmlEqualsResult;
    }

    String xmlToString(Document doc) throws TransformerException {
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
        transformer.setOutputProperty("method", "html");
        transformer.transform(domSource, result);
        return writer.toString();
    }

    public XmlEqualityChecker setOutputToLog(boolean outputToLog) {
        logger = outputToLog ? LoggerFactory.getLogger(XmlEqualityChecker.class) : null;
        return this;
    }

    static {
        BUILDER_FACTORY.setCoalescing(true);
        BUILDER_FACTORY.setIgnoringElementContentWhitespace(true);
        BUILDER_FACTORY.setIgnoringComments(true);
    }
}

