/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.security.xml.processor;

import com.sdl.delivery.security.xml.ResourceType;
import com.sdl.delivery.security.xml.XmlRestriction;
import com.tridion.util.log.LimitedFrequency;
import java.util.Arrays;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceTypeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceTypeProcessor.class);
    private static LimitedFrequency forLogger = LimitedFrequency.createOncePerMinute();

    ResourceTypeProcessor() {
    }

    String getForResourceType(ResourceType resourceType, XmlRestriction ... restrictions) {
        StringJoiner joiner = new StringJoiner(",");
        if (restrictions != null) {
            Arrays.stream(restrictions).filter(restriction -> restriction.getResourceType().equals((Object)resourceType)).forEach(restriction -> joiner.add(restriction.getProtocol()));
        }
        if (joiner.length() > 0) {
            return joiner.toString();
        }
        switch (resourceType) {
            case DTD: {
                return XmlRestriction.ALLOW_EXTERNAL_DTD_ALL.getProtocol();
            }
            case SCHEMA: {
                return XmlRestriction.ALLOW_EXTERNAL_SCHEMA_ALL.getProtocol();
            }
            case STYLESHEET: {
                return XmlRestriction.ALLOW_EXTERNAL_STYLESHEET_ALL.getProtocol();
            }
        }
        throw new IllegalArgumentException("Unknown resource type: " + resourceType);
    }

    void logMessage(String property, String message) {
        if (forLogger.isTimePassed()) {
            LOG.warn(message, (Object)property);
        }
    }

    static {
        System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
    }
}

