/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.security.xml.processor;

import com.sdl.delivery.security.xml.ResourceType;
import com.sdl.delivery.security.xml.XmlRestriction;
import com.sdl.delivery.security.xml.processor.ResourceTypeProcessor;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public class SecureDocumentBuilderFactoryProcessor
extends ResourceTypeProcessor {
    public DocumentBuilderFactory createFactory(XmlRestriction ... restrictions) {
        DocumentBuilderFactory factory = this.createDefaultFactory();
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(false);
        factory.setXIncludeAware(false);
        this.trySetAttribute(factory, "http://javax.xml.XMLConstants/property/accessExternalDTD", this.getForResourceType(ResourceType.DTD, restrictions));
        this.trySetAttribute(factory, "http://javax.xml.XMLConstants/property/accessExternalSchema", this.getForResourceType(ResourceType.SCHEMA, restrictions));
        this.trySetAttribute(factory, "http://javax.xml.XMLConstants/property/accessExternalStylesheet", this.getForResourceType(ResourceType.STYLESHEET, restrictions));
        this.trySetFeature(factory, "http://xml.org/sax/features/external-general-entities", false);
        this.trySetFeature(factory, "http://xml.org/sax/features/external-parameter-entities", false);
        this.trySetFeature(factory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        this.trySetFeature(factory, "http://apache.org/xml/features/disallow-doctype-decl", true);
        this.trySetFeature(factory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        return factory;
    }

    DocumentBuilderFactory createDefaultFactory() {
        return DocumentBuilderFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", ClassLoader.getSystemClassLoader());
    }

    void trySetFeature(DocumentBuilderFactory factory, String feature, boolean value) {
        try {
            factory.setFeature(feature, value);
        }
        catch (ParserConfigurationException e) {
            this.logMessage(feature, "Could not set feature to factory: {}");
        }
    }

    void trySetAttribute(DocumentBuilderFactory factory, String attribute, String value) {
        if ("all".equals(value) || value == null) {
            return;
        }
        try {
            factory.setAttribute(attribute, value);
        }
        catch (Exception e) {
            this.logMessage(attribute, "Could not set attribute '{}' to document builder factory");
        }
    }
}

