/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.security.xml.processor;

import com.sdl.delivery.security.xml.ResourceType;
import com.sdl.delivery.security.xml.XmlRestriction;
import com.sdl.delivery.security.xml.processor.ResourceTypeProcessor;
import com.tridion.util.exceptions.compacter.factory.CompacterFactory;
import com.tridion.util.exceptions.compacter.impl.StackTraceCompacter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureTransformerFactoryProcessor
extends ResourceTypeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SecureTransformerFactoryProcessor.class);
    private StackTraceCompacter compacter = CompacterFactory.getInstance();

    public SAXTransformerFactory createSaxTransformerFactory(XmlRestriction ... restrictions) {
        SAXTransformerFactory factory = this.createSaxDefaultFactory();
        if (restrictions == null) {
            return factory;
        }
        this.setSecurityFeaturesToTransformer(factory, restrictions);
        return factory;
    }

    private void setSecurityFeaturesToTransformer(TransformerFactory factory, XmlRestriction[] restrictions) {
        this.trySetFeature(factory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        this.trySetAttribute(factory, "http://javax.xml.XMLConstants/property/accessExternalDTD", this.getForResourceType(ResourceType.DTD, restrictions));
        this.trySetAttribute(factory, "http://javax.xml.XMLConstants/property/accessExternalStylesheet", this.getForResourceType(ResourceType.STYLESHEET, restrictions));
    }

    private void trySetFeature(TransformerFactory factory, String name, boolean value) {
        try {
            factory.setFeature(name, value);
        }
        catch (TransformerConfigurationException e) {
            this.logMessage(name, "Could not set feature to factory: {}");
        }
    }

    public TransformerFactory createTransformerFactory(XmlRestriction ... restrictions) {
        TransformerFactory factory = this.createDefaultFactory();
        if (restrictions == null) {
            return factory;
        }
        this.setSecurityFeaturesToTransformer(factory, restrictions);
        return factory;
    }

    public Transformer createTransformer(String stylesheet, Optional<Map<String, Object>> transformParameters, XmlRestriction ... restrictions) throws TransformerConfigurationException {
        Transformer transformer;
        TransformerFactory factory = this.createTransformerFactory(restrictions);
        if (stylesheet == null) {
            Transformer transformer2 = this.createNewTransformer(null, factory, restrictions);
            transformer2.setParameter("omit-xml-declaration", 0);
            transformer2.setParameter("indent", 0);
            return transformer2;
        }
        ByteArrayInputStream xslStream = new ByteArrayInputStream(stylesheet.getBytes(StandardCharsets.UTF_8));
        try {
            Transformer transformer3 = this.createNewTransformer(xslStream, factory, restrictions);
            transformer3.setParameter("omit-xml-declaration", 0);
            transformer3.setParameter("indent", 0);
            transformParameters.ifPresent(parameters -> parameters.forEach(transformer3::setParameter));
            transformer = transformer3;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)xslStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.compacter.init(e);
                LOG.trace("Could not create/init transformer with stylesheet: {}\n{}", (Object)stylesheet, (Object)this.compacter.generateString());
                throw new TransformerConfigurationException("Could not create/init transformer with stylesheet", e);
            }
        }
        ((InputStream)xslStream).close();
        return transformer;
    }

    Transformer createNewTransformer(InputStream inputStream, TransformerFactory factory, XmlRestriction[] restrictions) throws TransformerConfigurationException {
        Transformer transformer = inputStream != null ? factory.newTransformer(this.getStreamSource(inputStream)) : factory.newTransformer();
        transformer.setParameter("http://xml.org/sax/features/external-general-entities", false);
        transformer.setParameter("http://xml.org/sax/features/external-parameter-entities", false);
        transformer.setParameter("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        transformer.setParameter("http://javax.xml.XMLConstants/property/accessExternalSchema", this.getForResourceType(ResourceType.SCHEMA, restrictions));
        return transformer;
    }

    StreamSource getStreamSource(InputStream inputStream) {
        return new StreamSource(inputStream);
    }

    void trySetAttribute(TransformerFactory factory, String attribute, String value) {
        if ("all".equals(value) || value == null) {
            return;
        }
        try {
            factory.setAttribute(attribute, value);
        }
        catch (Exception e) {
            this.logMessage(attribute, "Could not set attribute '{}' to transformer factory");
        }
    }

    TransformerFactory createDefaultFactory() {
        return TransformerFactory.newInstance("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", ClassLoader.getSystemClassLoader());
    }

    SAXTransformerFactory createSaxDefaultFactory() {
        return (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    }
}

