/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.security.xml.processor;

import com.sdl.delivery.security.xml.XmlRestriction;
import com.sdl.delivery.security.xml.processor.ResourceTypeProcessor;
import javax.xml.stream.XMLInputFactory;

public class SecureXmlInputFactoryProcessor
extends ResourceTypeProcessor {
    public XMLInputFactory createSecureInputFactory(XmlRestriction[] restrictions) {
        XMLInputFactory factory = this.createDefaultFactory();
        this.setProperty(factory, "javax.xml.stream.supportDTD", false);
        this.setProperty(factory, "javax.xml.stream.isNamespaceAware", true);
        this.setProperty(factory, "javax.xml.stream.isSupportingExternalEntities", false);
        this.setProperty(factory, "javax.xml.stream.isReplacingEntityReferences", false);
        factory.setXMLResolver((publicID, systemID, baseURI, namespace) -> null);
        return factory;
    }

    XMLInputFactory createDefaultFactory() {
        return XMLInputFactory.newFactory();
    }

    void setProperty(XMLInputFactory factory, String property, Object value) {
        if (!factory.isPropertySupported(property)) {
            this.logMessage(property, "Factory " + factory.getClass().getCanonicalName() + " does not support property {}");
            return;
        }
        try {
            factory.setProperty(property, value);
        }
        catch (Exception ex) {
            this.logMessage(property, "Could not set property '{}' to input factory");
        }
    }
}

