/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.security.xml.processor;

import com.sdl.delivery.security.xml.XmlRestriction;
import com.sdl.delivery.security.xml.processor.ResourceTypeProcessor;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Objects;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SecureXmlValidatorProcessor
extends ResourceTypeProcessor {
    public Validator createValidator(InputStream xsdStream, XmlRestriction ... restrictions) throws SAXException {
        Objects.requireNonNull(xsdStream);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource schemaSource = new StreamSource(xsdStream);
        return this.createValidatorBySchema(factory.newSchema(schemaSource), restrictions);
    }

    public Validator createValidator(String xsdContent, XmlRestriction ... restrictions) throws SAXException {
        Objects.requireNonNull(xsdContent);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource schemaStream = new StreamSource(new StringReader(xsdContent));
        return this.createValidatorBySchema(factory.newSchema(schemaStream), restrictions);
    }

    Validator createValidatorBySchema(Schema schema, XmlRestriction ... restrictions) {
        Validator validator = schema.newValidator();
        this.trySetProperty(validator, "http://javax.xml.XMLConstants/property/accessExternalDTD", "false");
        this.trySetProperty(validator, "http://javax.xml.XMLConstants/property/accessExternalSchema", "false");
        this.trySetFeature(validator, "http://xml.org/sax/features/external-general-entities", false);
        this.trySetFeature(validator, "http://xml.org/sax/features/external-parameter-entities", false);
        return validator;
    }

    private void trySetProperty(Validator validator, String property, String value) {
        if ("all".equals(value) || value == null) {
            return;
        }
        try {
            validator.setProperty(property, value);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            this.logMessage(property, "Could not set property '{}' to validator");
        }
    }

    void trySetFeature(Validator validator, String feature, boolean value) {
        try {
            validator.setFeature(feature, value);
        }
        catch (SAXException e) {
            this.logMessage(feature, "Could not set feature '{}' to validator");
        }
    }
}

