/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.concurrent;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class LockManager<T> {
    private static final Logger LOG = LoggerFactory.getLogger(LockManager.class);
    public static final int DEFAULT_WAITING_TIME_MINUTES = 10;
    private final Map<T, Long> objectLocks = new HashMap<T, Long>();
    private final Lock lock = new ReentrantLock();
    private final Condition lockReleased = this.lock.newCondition();
    private final Random random = new Random(Thread.currentThread().getId());

    protected LockManager() {
    }

    public final long lock(T object) {
        if (object == null) {
            throw new IllegalArgumentException("Passed in a null.");
        }
        long lockCookie = this.random.nextLong();
        try {
            if (!this.lock.tryLock(10L, TimeUnit.MINUTES)) {
                throw new SecurityException("Could not acquire lock for: " + object + " within 10 minute");
            }
            while (this.objectLocks.containsKey(object)) {
                LOG.debug("{} already locked, awaiting signal.", object);
                this.lockReleased.await();
            }
            this.objectLocks.put(object, lockCookie);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupt signal detected");
        }
        finally {
            this.lock.unlock();
        }
        return lockCookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unlock(T object, long lockCookie) {
        block6: {
            if (object == null) {
                throw new IllegalArgumentException("Passed in a null.");
            }
            this.lock.lock();
            try {
                if (this.objectLocks.get(object) == lockCookie) {
                    this.objectLocks.remove(object);
                    this.lockReleased.signalAll();
                    break block6;
                }
                if (this.objectLocks.get(object) != null) {
                    throw new SecurityException("Invalid lockCookie is passed for: " + object);
                }
                throw new SecurityException("Lock is not found for: " + object);
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

