/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.configuration;

import com.tridion.crypto.Crypto;
import com.tridion.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableResolverUtil {
    private static final Logger LOG = LoggerFactory.getLogger(VariableResolverUtil.class);
    private static final String VARIABLE_START = "${";
    private static final String VARIABLE_END = "}";
    private static final String HIDDEN_MODIFIER = "*HIDDEN*";

    private VariableResolverUtil() {
    }

    public static String resolveValue(String value) {
        String variableStatement = VariableResolverUtil.getVariableStatement(value);
        if (StringUtils.isEmpty(variableStatement)) {
            return value;
        }
        String fullStatement = VARIABLE_START + variableStatement + VARIABLE_END;
        String[] parts = variableStatement.split(":-");
        Object resolvedValue = VariableResolverUtil.resolveVariable(parts);
        if (resolvedValue == null) {
            resolvedValue = fullStatement;
        }
        String result = value.replace(fullStatement, (CharSequence)resolvedValue);
        boolean isHidden = VariableResolverUtil.shouldBeHidden(parts);
        LOG.debug("Found parameter: {}. Resolved value: {}", (Object)value, isHidden ? "<hidden>" : resolvedValue);
        return result;
    }

    private static String getVariableStatement(String value) {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        int startIndex = value.indexOf(VARIABLE_START);
        if (startIndex < 0) {
            return null;
        }
        int endIndex = value.indexOf(VARIABLE_END, startIndex);
        if (endIndex < 0) {
            return null;
        }
        return value.substring(startIndex + VARIABLE_START.length(), endIndex);
    }

    private static String resolveVariable(String[] parts) {
        if (parts.length < 1) {
            return null;
        }
        String variableName = parts[0];
        String result = VariableResolverUtil.getEnvironmentVariable(variableName);
        return result != null ? result : VariableResolverUtil.getDefaultValue(parts);
    }

    public static String getEnvironmentVariable(String variableName) {
        String result = System.getenv(variableName);
        if (result == null) {
            result = System.getProperty(variableName);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPropertyFromPropertiesFile(String propertyFilePath, String propName) {
        try (InputStream applicationPropertiesInputStream = VariableResolverUtil.class.getClassLoader().getResourceAsStream(propertyFilePath);){
            if (applicationPropertiesInputStream == null) return null;
            Properties properties = new Properties();
            properties.load(applicationPropertiesInputStream);
            String string = (String)properties.get(propName);
            return string;
        }
        catch (IOException e) {
            LOG.warn("Unable to read {} from {} file", (Object)propName, (Object)propertyFilePath);
        }
        return null;
    }

    public static String getEnvironmentVariableAndDecrypt(String variableName) {
        String environmentVariable = VariableResolverUtil.getEnvironmentVariable(variableName);
        try {
            return Crypto.decryptIfNecessary(environmentVariable);
        }
        catch (GeneralSecurityException e) {
            LOG.warn("Unable to decrypt environment variable value: {}", (Object)environmentVariable);
            return null;
        }
    }

    private static String getDefaultValue(String[] parts) {
        String defaultValue;
        if (parts.length > 1 && !HIDDEN_MODIFIER.equalsIgnoreCase(defaultValue = parts[1])) {
            return defaultValue;
        }
        return null;
    }

    private static boolean shouldBeHidden(String[] parts) {
        for (String part : parts) {
            if (!HIDDEN_MODIFIER.equalsIgnoreCase(part)) continue;
            return true;
        }
        return false;
    }
}

