/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.util;

import java.lang.reflect.Array;
import java.util.Arrays;

public final class ArrayUtils {
    private static final int ARRAY_START_INDEX = 0;

    private ArrayUtils() {
    }

    public static <T> T[] concat(T[] a, T[] b) {
        int alength = a.length;
        int blength = b.length;
        Object[] result = (Object[])Array.newInstance(a.getClass().getComponentType(), alength + blength);
        System.arraycopy(a, 0, result, 0, alength);
        System.arraycopy(b, 0, result, alength, blength);
        return result;
    }

    public static byte[] concat(byte[] a, byte[] b) {
        int alength = a.length;
        int blength = b.length;
        byte[] result = Arrays.copyOf(a, alength + blength);
        System.arraycopy(b, 0, result, alength, blength);
        return result;
    }

    public static <T> boolean isNotEmpty(T[] a) {
        return a != null && a.length > 0;
    }

    public static boolean checkElementIndexIsInRange(int elementIndex, int length) {
        return elementIndex > 0 && elementIndex <= length;
    }
}

