/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CompressionUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final int EIGHT = 8;
    private static final int SIXTY_ONE = 61;
    private static final int TAB = 9;
    private static final int LF = 10;
    private static final int CR = 13;
    private static final int SPACE = 32;

    private CompressionUtils() {
    }

    public static boolean isCompressed(byte[] bytes) {
        if (bytes == null || bytes.length < 2) {
            return false;
        }
        return bytes[0] == 31 && bytes[1] == -117;
    }

    public static boolean isCompressed(String input) {
        if (input == null || input.length() == 0) {
            return false;
        }
        byte[] inputBytes = input.getBytes(StandardCharsets.UTF_8);
        if (CompressionUtils.isBase64Array(inputBytes)) {
            return CompressionUtils.isCompressed(Base64.getDecoder().decode(inputBytes));
        }
        return CompressionUtils.isCompressed(input.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] compressGZip(String input) {
        if (input == null || input.length() == 0) {
            return null;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gzipOutput = new GZIPOutputStream(baos);){
                gzipOutput.write(input.getBytes(StandardCharsets.UTF_8));
                gzipOutput.finish();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error while compressing!", e);
        }
    }

    public static String compressGZipAndBase64Encode(String input) {
        if (input == null || input.length() == 0) {
            return null;
        }
        return Base64.getEncoder().encodeToString(CompressionUtils.compressGZip(input));
    }

    public static String decodeAndDecompressGZip(String zippedBase64Str) {
        String result = null;
        if (!CompressionUtils.isCompressed(zippedBase64Str)) {
            byte[] decoded = Base64.getDecoder().decode(zippedBase64Str);
            return new String(decoded);
        }
        byte[] zipped = zippedBase64Str.getBytes(StandardCharsets.UTF_8);
        if (CompressionUtils.isBase64Array(zipped)) {
            zipped = Base64.getDecoder().decode(zipped);
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(zipped);
             GZIPInputStream gis = new GZIPInputStream(bais);){
            result = CompressionUtils.toString(gis, Charset.forName("UTF-8"));
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Error while decompressing.", ioe);
        }
        return result;
    }

    public static String toString(InputStream input, Charset encoding) throws IOException {
        StringWriter sw = new StringWriter();
        int n = 0;
        try (InputStreamReader in = new InputStreamReader(input, encoding);){
            char[] buffer = new char[4096];
            while (-1 != (n = in.read(buffer))) {
                sw.write(buffer, 0, n);
            }
            String string = sw.toString();
            return string;
        }
    }

    private static boolean isBase64Array(byte[] bytes) {
        for (byte b : bytes) {
            if (CompressionUtils.isBase64(b) || CompressionUtils.isWhiteSpace(b)) continue;
            return false;
        }
        return true;
    }

    private static boolean isBase64(byte octet) {
        return octet == 61 || octet >= 0 && octet < DECODE_TABLE.length && DECODE_TABLE[octet] != -1;
    }

    private static boolean isWhiteSpace(byte byteToCheck) {
        switch (byteToCheck) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }
}

