/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.util;

import com.tridion.util.TridionReflectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionUtil.class);

    private ReflectionUtil() {
    }

    public static <T> T loadClassInstanceWithType(String className, Class<T> subType, Class<?> classType, Object classParam) throws TridionReflectionException {
        return ReflectionUtil.loadClassInstanceWithTypes(className, subType, new Class[]{classType}, classParam);
    }

    public static <T> T loadClassInstanceWithTypes(String className, Class<T> subType, Class<?>[] constructorTypes, Object ... classParams) throws TridionReflectionException {
        try {
            Class<T> foundClass = Class.forName(className).asSubclass(subType);
            Constructor<T> foundConstructor = foundClass.getConstructor(constructorTypes);
            return foundConstructor.newInstance(classParams);
        }
        catch (ClassNotFoundException e) {
            throw new TridionReflectionException("Unable to load request class, was not found on classpath", e);
        }
        catch (IllegalArgumentException e) {
            throw new TridionReflectionException("The arguments passed to the class constructor are illegal", e);
        }
        catch (InstantiationException e) {
            throw new TridionReflectionException("The specified class is abstract or an interface", e);
        }
        catch (IllegalAccessException e) {
            throw new TridionReflectionException("The specified constructor is inaccesible", e);
        }
        catch (InvocationTargetException e) {
            LOG.error("The constructor of the target class has thrown an exception", (Throwable)e);
            throw new TridionReflectionException("The constructor of the target class has thrown an exception", e);
        }
        catch (SecurityException e) {
            throw new TridionReflectionException("The given constructor is not accessible for security reasons", e);
        }
        catch (NoSuchMethodException e) {
            throw new TridionReflectionException("Unable to locate a constructor in the target class with the given parameters", e);
        }
        catch (ClassCastException e) {
            throw new ClassCastException("The target class does not match the specified target type");
        }
    }

    public static <T> T loadClassInstance(String className, Class<T> subType, Object ... classParams) throws TridionReflectionException {
        Class[] paramTypes = new Class[classParams.length];
        for (int i = 0; i < classParams.length; ++i) {
            paramTypes[i] = classParams[i].getClass();
        }
        return ReflectionUtil.loadClassInstanceWithTypes(className, subType, paramTypes, classParams);
    }

    public static Object invokePrivateMethod(Object o, String methodName, Object[] params) throws TridionReflectionException {
        Objects.requireNonNull(o);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(params);
        for (Method method : ReflectionUtil.getAllMethods(o.getClass())) {
            if (!methodName.equals(method.getName())) continue;
            method.setAccessible(true);
            try {
                return method.invoke(o, params);
            }
            catch (IllegalAccessException e) {
                throw new TridionReflectionException("The specified method is inaccessible", e);
            }
            catch (InvocationTargetException e) {
                LOG.error("The method of the target class has thrown an exception", (Throwable)e);
                throw new TridionReflectionException("The method of the target class has thrown an exception", e);
            }
        }
        throw new TridionReflectionException("Unable to find the method '" + methodName + "' of " + o.getClass());
    }

    public static Object invokePrivateStaticMethod(Class c, String methodName, Object[] params) throws TridionReflectionException {
        Objects.requireNonNull(c);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(params);
        for (Method method : ReflectionUtil.getAllMethods(c)) {
            if (!Modifier.isStatic(method.getModifiers()) || !methodName.equals(method.getName())) continue;
            method.setAccessible(true);
            try {
                return method.invoke(null, params);
            }
            catch (IllegalAccessException e) {
                throw new TridionReflectionException("The specified method is inaccessible", e);
            }
            catch (InvocationTargetException e) {
                LOG.error("The method of the target class has thrown an exception", (Throwable)e);
                throw new TridionReflectionException("The method of the target class has thrown an exception", e);
            }
        }
        throw new TridionReflectionException("Unable to find the static method '" + methodName + "' of " + c);
    }

    private static List<Method> getAllMethods(Class<?> clazz) {
        ArrayList<Method> allMethods = new ArrayList<Method>();
        Collections.addAll(allMethods, clazz.getDeclaredMethods());
        if (clazz.getSuperclass() != null) {
            allMethods.addAll(ReflectionUtil.getAllMethods(clazz.getSuperclass()));
        }
        return allMethods;
    }

    public static Object getPrivateField(Object fieldOwner, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field privateField = fieldOwner.getClass().getDeclaredField(fieldName);
        privateField.setAccessible(true);
        return privateField.get(fieldOwner);
    }

    public static Object getPrivateField(Class fieldOwner, Object fieldOwnerInstance, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field privateField = fieldOwner.getDeclaredField(fieldName);
        privateField.setAccessible(true);
        return privateField.get(fieldOwnerInstance);
    }

    public static Object getPrivateFieldWithinSuperClasses(Object fieldOwner, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        List<Field> fields = ReflectionUtil.getAllFieldsRec(fieldOwner.getClass());
        for (Field field : fields) {
            if (!field.getName().equals(fieldName)) continue;
            field.setAccessible(true);
            return field.get(fieldOwner);
        }
        throw new NoSuchFieldException();
    }

    private static List<Field> getAllFieldsRec(Class<?> clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            list.addAll(ReflectionUtil.getAllFieldsRec(superClazz));
        }
        list.addAll(Arrays.asList(clazz.getDeclaredFields()));
        return list;
    }

    public static void setPrivateField(Object fieldOwner, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field privateField = fieldOwner.getClass().getDeclaredField(fieldName);
        privateField.setAccessible(true);
        privateField.set(fieldOwner, value);
    }

    public static void setPrivateField(Class fieldOwner, Object fieldOwnerInstance, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field privateField = fieldOwner.getDeclaredField(fieldName);
        privateField.setAccessible(true);
        privateField.set(fieldOwnerInstance, value);
    }
}

