/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ZipUtils.class);
    private static final int DEFAULT_BYTE_ARRAY_SIZE = 1024;

    private ZipUtils() {
    }

    public static File createArchive(File source) throws IOException {
        String destination = source.isDirectory() ? source.getParentFile().getCanonicalPath() + File.separatorChar + source.getName() + ".zip" : source.getCanonicalPath() + ".zip";
        LOG.debug("Creating archive " + destination + " based on " + source.getCanonicalPath());
        return ZipUtils.createArchive(source, new File(destination));
    }

    public static File createArchive(String source) throws IOException {
        return ZipUtils.createArchive(new File(source));
    }

    public static File createArchive(File source, File destination) throws IOException {
        return ZipUtils.createArchive(source, destination, false);
    }

    public static File createArchive(String source, String destination) throws IOException {
        return ZipUtils.createArchive(new File(source), new File(destination));
    }

    public static synchronized File createArchive(File source, File destination, boolean overwrite) throws IOException {
        File newDestination = destination;
        if (newDestination.isDirectory()) {
            newDestination = new File(newDestination.getCanonicalPath() + File.separatorChar + source.getName() + ".zip");
        }
        if (!overwrite && newDestination.exists()) {
            return newDestination;
        }
        if (source.isDirectory()) {
            new net.lingala.zip4j.ZipFile(newDestination).addFolder(source);
        } else {
            new net.lingala.zip4j.ZipFile(newDestination).addFile(source);
        }
        return newDestination;
    }

    public static File createArchive(String source, String destination, boolean overwrite) throws IOException {
        return ZipUtils.createArchive(new File(source), new File(destination), overwrite);
    }

    public static void unzip(File source, File destination) throws IOException {
        ZipUtils.unzip(source, destination, false);
    }

    public static void unzip(File source, File destination, boolean preventDirectoryTraversalCharacters) throws IOException {
        if (destination.mkdirs()) {
            LOG.trace("Created {}", (Object)destination);
        }
        if (!destination.isDirectory()) {
            throw new IOException("Destination for expanding an archive should be a directory!");
        }
        try (ZipFile zipFile = new ZipFile(source);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            byte[] buffer = new byte[1024];
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (preventDirectoryTraversalCharacters && (entryName.contains("../") || entryName.contains("..\\"))) {
                    throw new IOException("Zip package contains file with directory traversal characters. This is not allowed due to security violation. File: " + entryName);
                }
                String outName = destination.getCanonicalPath() + File.separatorChar + entryName;
                File outFile = new File(outName);
                if (entry.isDirectory()) {
                    if (outFile.mkdirs()) {
                        LOG.trace("Created {}", (Object)outFile);
                    }
                } else {
                    if (outFile.getParentFile().mkdirs()) {
                        LOG.trace("Created {}", (Object)outFile.getParentFile().toString());
                    }
                    try (FileOutputStream outStream = new FileOutputStream(outFile);
                         InputStream inStream = zipFile.getInputStream(entry);){
                        int total = 0;
                        while ((long)total < entry.getSize()) {
                            int read = inStream.read(buffer);
                            outStream.write(buffer, 0, read);
                            total += read;
                        }
                    }
                }
                LOG.debug("Uncompressed " + outName);
            }
        }
    }
}

