/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.util.convertions;

import com.tridion.util.convertions.Convertor;

public class ConvertionUtils {
    private static final double ROUND_FRACT = 1.0E-6;

    private ConvertionUtils() {
    }

    public static String convertToString(Convertor convertor, Double number, int blocks, boolean withWhiteSpace) {
        if (convertor == null) {
            throw new IllegalArgumentException();
        }
        if (number == null || number.isNaN()) {
            throw new IllegalArgumentException("Cannot be null or NaN, but was " + number);
        }
        if (number < 0.0) {
            number = -number.doubleValue();
        }
        if (number.isInfinite()) {
            return "Infinite";
        }
        if (Math.abs(number) < 1.0E-6) {
            return "0";
        }
        Convertor.Names names = convertor.getNames();
        int count = 1;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < names.getNames().size(); ++i) {
            Convertor.Holder holder = names.getNames().get(i);
            double head = Math.floor(number / holder.getDivider());
            if (head <= 0.0) continue;
            number = number - head * holder.getDivider();
            result.append((long)head).append(withWhiteSpace ? " " : "").append((long)head == 1L ? holder.getNameSingular() : holder.getNamePlural()).append(" ");
            if (blocks > 0 && count >= blocks) break;
            ++count;
        }
        return result.toString().trim();
    }

    public static String convertToString(Convertor convertor, Double number, int blocks) {
        return ConvertionUtils.convertToString(convertor, number, blocks, true);
    }
}

