/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.util.exceptions.compacter.impl;

import com.tridion.util.log.LimitedFrequency;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class StackTraceCompacter {
    private static final int DEFAULT_LENGTH = 512;
    private static final AtomicInteger NUMBER_ONE = new AtomicInteger(1);
    private static final int MAX_COMPACTED_LINE_LENGTH = 130;
    private static final String AT_ADDON = "\n\tat ";
    private static final int AMOUNT_OF_SKIPPED_TRACES = 100;
    private static volatile boolean shouldNotCompact = false;
    private static LimitedFrequency limitedFrequency = LimitedFrequency.createOncePerTenSeconds();
    private final List<ProcessorRule> allRulesToCollapse = Arrays.asList(new ProcessorRule("-- Reflection", new String[]{"java.lang.reflect.", "sun.reflect.", "jdk.internal.reflect."}), new ProcessorRule("-- Tomcat", new String[]{"org.apache.catalina.", "org.apache.coyote.", "org.apache.tomcat."}), new ProcessorRule("-- Websphere", new String[]{"com.ibm.ws.", "com.ibm.websphere."}), new ProcessorRule("-- Spring", "org.springframework."), new ProcessorRule("-- Freemarker", "freemarker."), new ProcessorRule("-- Jackson", "com.fasterxml.jackson."), new ProcessorRule("-- ActiveMQ", "org.apache.activemq."), new ProcessorRule("-- Hibernate", "org.hibernate."), new ProcessorRule("-- DB driver (MS SQL)", "com.microsoft.sqlserver."), new ProcessorRule("-- DB driver (MySQL)", "com.mysql."), new ProcessorRule("-- DB driver (Oracle)", "oracle.jdbc."), new ProcessorRule("-- JUnit", "org.junit."), new ProcessorRule("-- Mockito", "org.mockito."), new ProcessorRule("-- IntelliJ IDEA", "com.intellij."));
    private Throwable currentException;
    private String compactedBody;
    private final Stack<StackTraceHolder> stackTraceElements = new Stack();
    private final List<ProcessorRule> allRulesToLeftExpanded = new ArrayList<ProcessorRule>();
    private final ConcurrentMap<Integer, AtomicInteger> collectedExceptions = new ConcurrentHashMap<Integer, AtomicInteger>();

    public StackTraceCompacter() {
    }

    public StackTraceCompacter(Throwable currentException) {
        this.init(currentException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Throwable throwable) {
        StackTraceCompacter stackTraceCompacter;
        this.currentException = throwable;
        if (limitedFrequency.isTimePassed()) {
            if (System.getProperty("stacktrace.compacter.off") != null) {
                shouldNotCompact = true;
                this.collectedExceptions.clear();
            } else {
                shouldNotCompact = false;
            }
            stackTraceCompacter = this;
            synchronized (stackTraceCompacter) {
                this.stackTraceElements.clear();
            }
        }
        if (shouldNotCompact) {
            return;
        }
        stackTraceCompacter = this;
        synchronized (stackTraceCompacter) {
            this.stackTraceElements.clear();
            for (StackTraceElement element : throwable.getStackTrace()) {
                StackTraceHolder last = this.stackTraceElements.isEmpty() ? null : this.stackTraceElements.peek();
                String canonicalName = element.toString();
                boolean noRuleMet = true;
                for (ProcessorRule rule : this.allRulesToCollapse) {
                    if (!rule.processCurrentLine(canonicalName)) continue;
                    if (last != null && last.isCompacted() && last.ruleWhichMet == rule) {
                        last.incrementCounter();
                        noRuleMet = false;
                        break;
                    }
                    this.stackTraceElements.push(new StackTraceHolder(element));
                    last = this.stackTraceElements.peek();
                    last.ruleWhichMet = rule;
                    last.setCompactName(rule.compactedName);
                    last.incrementCounter();
                    noRuleMet = false;
                    break;
                }
                if (!noRuleMet) continue;
                this.stackTraceElements.push(new StackTraceHolder(element));
            }
        }
        this.compactedBody = this.generateString(false);
        AtomicInteger counterOfExceptionNew = new AtomicInteger(1);
        AtomicInteger counterOfExceptionOld = this.collectedExceptions.putIfAbsent(this.compactedBody.hashCode(), counterOfExceptionNew);
        if (counterOfExceptionOld != null) {
            counterOfExceptionOld.incrementAndGet();
            if (this.collectedExceptions.size() > 100) {
                this.collectedExceptions.clear();
                this.collectedExceptions.put(this.compactedBody.hashCode(), counterOfExceptionNew);
            }
        }
    }

    public void addRuleToCollapse(String compactedName, String[] rule) {
        this.allRulesToCollapse.add(new ProcessorRule(compactedName, rule));
    }

    public void addRuleToBeLeftExpanded(String ruleName, String[] rule) {
        this.allRulesToLeftExpanded.add(new ProcessorRule(ruleName, rule));
    }

    public List<ProcessorRule> getAllRules() {
        return Collections.unmodifiableList(this.allRulesToLeftExpanded);
    }

    public String generateString() {
        return this.generateString(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateString(boolean generateHeader) {
        if (shouldNotCompact) {
            if (this.currentException == null) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream stream = new PrintStream(new BufferedOutputStream(out));
            this.currentException.printStackTrace(stream);
            this.currentException = null;
            return out.toString();
        }
        StackTraceCompacter stackTraceCompacter = this;
        synchronized (stackTraceCompacter) {
            if (this.currentException == null) {
                return "No exception provided";
            }
            if (this.currentException.getStackTrace() == null) {
                return "No stacktrace provided";
            }
            if (this.currentException.getStackTrace().length == 0) {
                return "No any stacktrace element provided";
            }
            StringBuilder result = new StringBuilder(512);
            if (generateHeader) {
                int counter = this.collectedExceptions.getOrDefault(this.compactedBody.hashCode(), NUMBER_ONE).get();
                if (counter != 1) {
                    result.append("Exception ('" + this.compactedBody.hashCode() + "') has been thrown #" + counter + " times: ");
                    result.append(this.currentException.toString()).append("\n");
                    return result.toString();
                }
                result.append("Here's a compacted exception ('" + this.compactedBody.hashCode() + "')");
                result.append("\n");
                result.append(this.compactedBody).append("\n");
                return result.toString();
            }
            result.append(this.currentException.toString());
            int lineLength = 0;
            boolean compactedLine = false;
            for (StackTraceHolder element : this.stackTraceElements) {
                if (!element.isCompacted()) {
                    result.append(AT_ADDON).append(element);
                    continue;
                }
                String append = element.toString();
                if (lineLength == 0) {
                    result.append(AT_ADDON);
                    lineLength += AT_ADDON.length() + 1;
                    if (!compactedLine) {
                        result.append(append);
                        lineLength += append.length();
                    }
                }
                if (compactedLine) {
                    result.append(append);
                    lineLength += append.length();
                }
                compactedLine = element.isCompacted();
                if (lineLength <= 130) continue;
                compactedLine = false;
                lineLength = 0;
            }
            for (Throwable cause = this.currentException.getCause(); cause != null; cause = cause.getCause()) {
                StackTraceCompacter innerShortener = new StackTraceCompacter(cause);
                result.append("Caused by: \n");
                String inner = innerShortener.generateString();
                result.append(inner);
                if (cause == cause.getCause()) break;
            }
            return result.toString();
        }
    }

    private static class ProcessorRule {
        private final Set<String> rules = new HashSet<String>();
        private final String compactedName;

        ProcessorRule(String compactedName, String rule) {
            this.rules.add(rule);
            this.compactedName = compactedName;
        }

        ProcessorRule(String compactedName, String[] rules) {
            Arrays.asList(rules).forEach(this.rules::add);
            this.compactedName = compactedName;
        }

        boolean processCurrentLine(String className) {
            return this.rules.stream().anyMatch(className::contains);
        }

        public String toString() {
            return "ProcessorRule{" + this.compactedName + "}";
        }
    }

    private static class StackTraceHolder {
        private StackTraceElement element;
        private int counter = 0;
        private boolean compacted = false;
        private ProcessorRule ruleWhichMet;
        private String compactName;

        StackTraceHolder(StackTraceElement element) {
            this.element = element;
        }

        void incrementCounter() {
            ++this.counter;
        }

        int getCounter() {
            return this.counter;
        }

        void setCompactName(String compactName) {
            this.compactName = compactName;
            this.compacted = true;
        }

        boolean isCompacted() {
            return this.compacted;
        }

        public String toString() {
            if (!this.compacted) {
                return this.element.toString();
            }
            if (this.counter > 1) {
                return "\t" + this.compactName + "\t<" + this.counter + " lines>";
            }
            return "\t" + this.compactName;
        }
    }
}

