/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.util.log;

import com.tridion.util.convertions.ConvertionUtils;
import com.tridion.util.convertions.DateConvertor;
import com.tridion.util.convertions.KphConvertor;
import com.tridion.util.log.Progressor;

public class DefaultProgressIndicator
implements Progressor {
    private static final long NANOS_IN_MILLIS = 1000000L;
    private static final double HUNDRED_PERCENTS = 100.0;
    private static final int BLOCKS = 3;
    private static final double SEC_IN_HOUR = 3600.0;
    private static final double MILLIS_IN_SEC = 1000.0;
    private static final double MIN_TIME = 0.001;
    private String message;
    private long startTime = System.nanoTime();
    private long currentStep;
    private long totalStepsAmount;
    private volatile boolean completed;

    public DefaultProgressIndicator(String message) {
        this.message = message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void setSteps(long steps) {
        if (steps < 0L) {
            throw new IllegalArgumentException();
        }
        this.setTotalStepsAmount(steps);
    }

    @Override
    public void nextStep() {
        if (this.completed) {
            throw new IllegalStateException("Already completed");
        }
        this.setCurrentStep(this.getCurrentStep() + 1L);
        if (this.getCurrentStep() > this.getTotalStepsAmount()) {
            this.setTotalStepsAmount(this.getCurrentStep());
        }
    }

    @Override
    public void complete() {
        this.completed = true;
    }

    @Override
    public void close() {
        this.complete();
    }

    public String toString() {
        if (this.getTotalStepsAmount() == 0L) {
            return "";
        }
        double seconds = this.getSpentTime() / 1000.0;
        if (seconds == 0.0) {
            seconds = 0.001;
        }
        double speed = 3600.0 * (double)this.getCurrentStep() / seconds / 1000.0;
        double remain = (double)(this.getTotalStepsAmount() - this.getCurrentStep()) / (speed * 1000.0) * 3600.0;
        String speedS = ConvertionUtils.convertToString(KphConvertor.get(), speed, 2);
        return "Completed " + String.format("%1$4.2f", this.getProgressPercent()) + " %. Processed " + this.getStepOfSteps() + ". (" + speedS + "). " + (String)(seconds > 1.0 ? ConvertionUtils.convertToString(DateConvertor.get(), seconds, 3) + " elapsed. " : "") + (String)(remain > 1.0 ? ConvertionUtils.convertToString(DateConvertor.get(), remain, 3) + " remain." : "") + (String)(this.message == null ? "" : " [" + this.message + "]") + (String)(this.completed ? " in " + ConvertionUtils.convertToString(DateConvertor.get(), seconds, 3) : "");
    }

    private String getStepOfSteps() {
        if (this.getCurrentStep() == this.getTotalStepsAmount()) {
            return "all " + String.format("%1$6d", this.getCurrentStep()) + " items";
        }
        return String.format("%1$6d", this.getCurrentStep()) + " items of " + String.format("%1$6d", this.getTotalStepsAmount());
    }

    private double getProgressPercent() {
        return 100.0 * ((double)this.getCurrentStep() / (double)this.getTotalStepsAmount());
    }

    public double getSpentTime() {
        return (System.nanoTime() - this.startTime + 1L) / 1000000L;
    }

    public boolean isFinished() {
        return this.completed;
    }

    public long getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(long currentStep) {
        this.currentStep = currentStep;
    }

    long getTotalStepsAmount() {
        return this.totalStepsAmount;
    }

    void setTotalStepsAmount(long totalStepsAmount) {
        this.totalStepsAmount = totalStepsAmount;
    }
}

