/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.util.log;

import java.util.concurrent.TimeUnit;

public class LimitedFrequency {
    private static final long NANOS_IN_MILLIS = 1000000L;
    private volatile long lastAccessTime;
    private final long delayTime;
    private static final int ONCE_PER_TEN_SECOND = 10;

    public LimitedFrequency(long delayTime) {
        this.delayTime = delayTime;
    }

    public static LimitedFrequency createOncePerTenSeconds() {
        return new LimitedFrequency(TimeUnit.SECONDS.toMillis(10L));
    }

    public static LimitedFrequency createOncePerMinute() {
        return new LimitedFrequency(TimeUnit.MINUTES.toMillis(1L));
    }

    public boolean isTimePassed() {
        long currentTime = System.nanoTime() / 1000000L;
        if (this.lastAccessTime == 0L) {
            this.lastAccessTime = currentTime;
            return false;
        }
        if (this.lastAccessTime < currentTime - this.delayTime) {
            this.lastAccessTime = currentTime;
            return true;
        }
        return false;
    }

    public long get() {
        return System.nanoTime() / 1000000L - this.delayTime;
    }
}

