/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.util.log;

import com.tridion.util.log.DefaultProgressIndicator;
import com.tridion.util.log.LimitedFrequency;
import com.tridion.util.log.Progressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogProgressIndicator
extends DefaultProgressIndicator
implements Progressor {
    private static final Logger LOG = LoggerFactory.getLogger(LogProgressIndicator.class);
    private static final long TIME_TO_WAIT = 15000L;
    private static final int MINIMAL_TIME_TO_WAIT = 10;
    private final LimitedFrequency limitedFrequency;
    private boolean skipFirstLogEntry = false;

    public LogProgressIndicator(String message, long timeToWait, boolean skipFirstLogEntry) {
        super(message);
        this.skipFirstLogEntry = skipFirstLogEntry;
        if (timeToWait < 10L) {
            timeToWait = 10L;
        }
        this.limitedFrequency = new LimitedFrequency(timeToWait);
    }

    public LogProgressIndicator(String message, long timeToWait) {
        this(message, timeToWait, true);
    }

    public LogProgressIndicator(String message) {
        this(message, 15000L);
    }

    @Override
    public void nextStep() {
        super.nextStep();
        if (this.getCurrentStep() >= this.getTotalStepsAmount()) {
            return;
        }
        if (this.skipFirstLogEntry) {
            this.skipFirstLogEntry = false;
            return;
        }
        if (this.limitedFrequency.isTimePassed()) {
            LOG.warn(this.toString());
        }
    }

    @Override
    public void complete() {
        super.complete();
        String message = this.toString();
        if (this.isNullOrEmpty(message)) {
            return;
        }
        LOG.warn(message);
    }

    private boolean isNullOrEmpty(String message) {
        return message == null || message.isEmpty();
    }
}

