/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.util.performance;

import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Performance
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"profiling");
    private static final long MILLION = 1000000L;
    private final long startTime = System.nanoTime();
    private long totalTime;
    private long warnIfMoreThanMillis = 2L;
    private String name = Thread.currentThread().getName();
    private static final AtomicInteger COUNTER = new AtomicInteger();

    public Performance() {
    }

    public Performance(long warnIfMoreThanMillis) {
        this.warnIfMoreThanMillis = warnIfMoreThanMillis;
    }

    public Performance(long warnIfMoreThanMillis, String name) {
        this(warnIfMoreThanMillis);
        this.name = name;
    }

    public Performance(String name) {
        this.name = name;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    @Override
    public void close() {
        COUNTER.incrementAndGet();
        this.totalTime = (System.nanoTime() - this.startTime) / 1000000L;
        if (this.totalTime >= this.warnIfMoreThanMillis) {
            LOGGER.debug("{} took {} ms (" + COUNTER.get() + " times)", (Object)this.name, (Object)this.totalTime);
        }
    }
}

