/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.util.xml;

import com.tridion.configuration.VariableResolverUtil;
import com.tridion.util.StringUtils;
import com.tridion.util.xml.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLMergeUtil {
    private static final Object XML_MERGE_UTIL_LOCK = new Object();
    private final DocumentBuilder documentBuilder;
    private final String schemaFile;
    private final Validator validator;

    public XMLMergeUtil(String schemaFile) throws IOException, SAXException, ParserConfigurationException {
        block8: {
            if (StringUtils.isEmpty(schemaFile)) {
                throw new IOException("Given schema file was null.");
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.schemaFile = schemaFile;
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(schemaFile);){
                if (inputStream != null) {
                    StreamSource schemaSource = new StreamSource(inputStream);
                    Schema schema = factory.newSchema(schemaSource);
                    this.validator = schema.newValidator();
                    this.validator.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    this.validator.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    break block8;
                }
                throw new IOException("No schema located at: '" + schemaFile + "'");
            }
        }
    }

    private void validateConfiguration(Node domNode) throws IOException, SAXException {
        this.validator.validate(new DOMSource(domNode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node merge(Node master, Node merge) throws SAXException {
        if (master == null) {
            throw new NullPointerException("The XML master configuration node is required");
        }
        if (merge == null) {
            throw new NullPointerException("The XML configuration node to be merged is required");
        }
        try {
            this.validateConfiguration(master);
        }
        catch (IOException | SAXException e) {
            throw new SAXException("Original Configuration cannot be validated against given schema: " + this.schemaFile, e);
        }
        Object object = XML_MERGE_UTIL_LOCK;
        synchronized (object) {
            Document document = this.documentBuilder.newDocument();
            Node importedOriginalRootNode = document.importNode(master, true);
            document.appendChild(importedOriginalRootNode);
            Node appendRootNote = merge.cloneNode(true);
            this.mergeXmlLevel((Element)importedOriginalRootNode, document, appendRootNote);
            return importedOriginalRootNode;
        }
    }

    private void mergeXmlLevel(Element originalElementPointer, Document document, Node mergeNode) {
        block8: while (mergeNode.hasChildNodes()) {
            Node mergeNodeChild = mergeNode.getFirstChild();
            mergeNode.removeChild(mergeNodeChild);
            switch (mergeNodeChild.getNodeType()) {
                case 3: {
                    if (!StringUtils.isNotEmpty(StringUtils.trimIfNotNull(mergeNodeChild.getTextContent()))) break;
                    originalElementPointer.setTextContent(mergeNodeChild.getTextContent());
                    break;
                }
                case 1: {
                    NodeList nodeList = originalElementPointer.getElementsByTagName(mergeNodeChild.getNodeName());
                    Node clonedMergeChild = document.importNode(mergeNodeChild, true);
                    if (nodeList.getLength() == 0) {
                        originalElementPointer.appendChild(clonedMergeChild);
                        try {
                            this.validateConfiguration(document.getDocumentElement());
                        }
                        catch (IOException | SAXException e) {
                            originalElementPointer.removeChild(clonedMergeChild);
                        }
                        break;
                    }
                    if (nodeList.getLength() <= 0) break;
                    originalElementPointer.appendChild(clonedMergeChild);
                    try {
                        this.validateConfiguration(document.getDocumentElement());
                        break;
                    }
                    catch (IOException | SAXException e) {
                        originalElementPointer.removeChild(clonedMergeChild);
                        Element lastItem = (Element)nodeList.item(nodeList.getLength() - 1);
                        NamedNodeMap attributes = mergeNodeChild.getAttributes();
                        for (int i = 0; i < attributes.getLength(); ++i) {
                            Node attribute = attributes.item(i);
                            attribute.setNodeValue(VariableResolverUtil.resolveValue(attribute.getNodeValue()));
                            Attr attributeClone = (Attr)document.importNode(attribute, false);
                            lastItem.setAttributeNode(attributeClone);
                        }
                        for (Node c : XmlUtil.asList(nodeList)) {
                            this.mergeXmlLevel((Element)c, document, mergeNodeChild);
                        }
                        continue block8;
                    }
                }
            }
        }
    }
}

