/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.util.xml;

import com.sdl.delivery.security.xml.SecureXmlProcessingUtils;
import com.sdl.delivery.security.xml.XmlRestriction;
import com.tridion.util.xml.DOMWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XMLUtils.class);
    private static final int BOM_SIZE = 3;
    private static final String BOM_UTF8 = "\u00ef\u00bb\u00bf";
    private static final String INVALID_CHAR_EXCLUDE_PATTERN = "[^\\w]";
    private static final Pattern ONLY_LETTERS_PATTERN = Pattern.compile("[a-zA-Z]");

    private XMLUtils() {
    }

    public static Element getElement(Document doc, String tagName, int index) {
        NodeList rows = doc.getDocumentElement().getElementsByTagName(tagName);
        return (Element)rows.item(index);
    }

    public static int getSize(Document doc, String tagName) {
        NodeList rows = doc.getDocumentElement().getElementsByTagName(tagName);
        return rows.getLength();
    }

    public static String getValue(Element e, String tagName) {
        try {
            NodeList elements = e.getElementsByTagName(tagName);
            Node node = elements.item(0);
            if (node != null) {
                NodeList nodes = node.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    String s = nodes.item(i).getNodeValue().trim();
                    if (s.equals("") || s.equals("\r")) continue;
                    return s;
                }
            }
            return null;
        }
        catch (Exception ex) {
            LOG.error("Error", (Throwable)ex);
            return null;
        }
    }

    public static Element getFirstElement(Element parent, String tagName) {
        try {
            NodeList elements = parent.getElementsByTagName(tagName);
            Node node = elements.item(0);
            if (node instanceof Element) {
                Element e = (Element)node;
                return e;
            }
        }
        catch (Exception ex) {
            LOG.error("Error", (Throwable)ex);
        }
        return null;
    }

    public static String getAttributeValue(Element parent, String tagName, String attributeName) {
        try {
            NodeList elements = parent.getElementsByTagName(tagName);
            Node node = elements.item(0);
            if (node instanceof Element) {
                Element e = (Element)node;
                return e.getAttribute(attributeName);
            }
        }
        catch (Exception ex) {
            LOG.error("Error", (Throwable)ex);
        }
        return null;
    }

    public static String getAttributeValue(Document parent, String tagName, String attributeName) {
        try {
            NodeList elements = parent.getElementsByTagName(tagName);
            Node node = elements.item(0);
            if (node instanceof Element) {
                Element e = (Element)node;
                return e.getAttribute(attributeName);
            }
        }
        catch (Exception ex) {
            LOG.error("Error", (Throwable)ex);
        }
        return null;
    }

    public static void printNodeTypes(NodeList rows) {
        System.out.println("\tenumerating NodeList (of Elements):");
        System.out.println("\tClass\tNT\tNV");
        for (int ri = 0; ri < rows.getLength(); ++ri) {
            Node n = rows.item(ri);
            if (n instanceof Element) {
                System.out.print("\tElement");
            } else {
                System.out.print("\tNode");
            }
            System.out.println("\t" + n.getNodeType() + "\t" + n.getNodeValue());
        }
        System.out.println();
    }

    public static String convertDocumentToString(Document document) {
        StringWriter stringWriter = new StringWriter();
        DOMWriter domWriter = new DOMWriter();
        domWriter.setOutput(stringWriter);
        domWriter.write(document);
        return stringWriter.toString();
    }

    public static List<Object> convertContentToDocument(byte[] content) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = SecureXmlProcessingUtils.createDocumentBuilderFactory(XmlRestriction.makeForLocalFiles());
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        InputSource inputSource = new InputSource(new ByteArrayInputStream(content));
        Document document = documentBuilder.parse(inputSource);
        Node root = document.getFirstChild();
        NodeList children = root.getChildNodes();
        int size = children.getLength();
        ArrayList<Object> renderAddedMD = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            if (children.item(i).getNodeType() == 3) continue;
            renderAddedMD.add(children.item(i));
        }
        return renderAddedMD;
    }

    public static String removeBOMForUTF8(String content) {
        if (content != null && content.startsWith(BOM_UTF8)) {
            content = content.substring(3);
        }
        return content;
    }

    public static Object escape(Object content) {
        if (!(content instanceof String)) {
            return content;
        }
        StringBuilder result = new StringBuilder(((String)content).length());
        StringCharacterIterator characterIterator = new StringCharacterIterator((String)content);
        char character = characterIterator.current();
        while (character != '\uffff') {
            switch (character) {
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                case '\'': {
                    result.append("&#039;");
                    break;
                }
                case '\"': {
                    result.append("&quot;");
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                default: {
                    result.append(character);
                }
            }
            character = characterIterator.next();
        }
        return result.toString();
    }

    public static Element loadXML(InputStream xmlStream) {
        try {
            DocumentBuilderFactory factory = SecureXmlProcessingUtils.createDocumentBuilderFactory(XmlRestriction.makeForLocalFiles());
            factory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.parse(xmlStream);
            return document.getDocumentElement();
        }
        catch (Exception e) {
            LOG.warn("Error while processing ", (Throwable)e);
            return null;
        }
    }

    public static String removeNonAlphaNumericChars(String originalString) {
        if (originalString != null && ((originalString = originalString.replaceAll(INVALID_CHAR_EXCLUDE_PATTERN, "")).isEmpty() || !ONLY_LETTERS_PATTERN.matcher(originalString.substring(0, 1)).matches())) {
            originalString = "";
        }
        return originalString;
    }
}

