/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.deployment.api;

import com.tridion.util.CMURI;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemKey
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ItemKey.class);
    private static final long serialVersionUID = 8819185995707150593L;
    private CMURI cmUri;

    public ItemKey() {
    }

    public ItemKey(CMURI cmUri) {
        this.cmUri = cmUri;
    }

    public ItemKey(String uri) {
        this.cmUri = ItemKey.toCMURI(uri);
    }

    public CMURI getCmUri() {
        return this.cmUri;
    }

    public void setCmUri(CMURI cmUri) {
        this.cmUri = cmUri;
    }

    protected static CMURI toCMURI(String uri) {
        try {
            return new CMURI(uri);
        }
        catch (ParseException e) {
            LOG.error("Unable to construct CMURI from: {}", (Object)uri);
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemKey itemKey = (ItemKey)o;
        return Objects.equals(this.cmUri, itemKey.cmUri);
    }

    public int hashCode() {
        return Objects.hash(this.cmUri);
    }

    public String toString() {
        return this.cmUri.toString();
    }
}

