/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.data;

import com.tridion.data.BinaryData;
import com.tridion.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BinaryDataBuffer
implements BinaryData {
    private int namespaceId;
    private byte[] binaryContent;
    private int id;
    private int publicationId;
    private String variantId;

    public BinaryDataBuffer(int namespaceId, int publicationId, int binaryId, byte[] binaryContent) {
        this(namespaceId, publicationId, binaryId, binaryContent, null);
    }

    public BinaryDataBuffer(int namespaceId, int publicationId, int binaryId, byte[] binaryContent, String variantId) {
        this.namespaceId = namespaceId;
        this.binaryContent = binaryContent;
        this.id = binaryId;
        this.publicationId = publicationId;
        this.variantId = StringUtils.normalizeString((String)variantId);
    }

    @Override
    public byte[] getBytes() throws IOException {
        return this.binaryContent;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getVariantId() {
        return this.variantId;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.binaryContent);
    }

    @Override
    public int getNamespaceId() {
        return this.namespaceId;
    }

    @Override
    public int getPublicationId() {
        return this.publicationId;
    }

    @Override
    public long getDataSize() {
        return this.binaryContent.length;
    }
}

