/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.data;

import com.tridion.data.BinaryData;
import com.tridion.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BinaryDataFile
implements BinaryData {
    private File binaryFile;
    private int namespaceId;
    private int id;
    private int publicationId;
    private String variantId;

    public BinaryDataFile(int namespaceId, int publicationId, int binaryId, File binaryFile) {
        this(namespaceId, publicationId, binaryId, binaryFile, null);
    }

    public BinaryDataFile(int namespaceId, int publicationId, int binaryId, File binaryFile, String variantId) {
        this.namespaceId = namespaceId;
        this.binaryFile = binaryFile;
        this.id = binaryId;
        this.publicationId = publicationId;
        this.variantId = StringUtils.normalizeString((String)variantId);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getNamespaceId() {
        return this.namespaceId;
    }

    @Override
    public int getPublicationId() {
        return this.publicationId;
    }

    @Override
    public String getVariantId() {
        return this.variantId;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.binaryFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes() throws IOException {
        try (InputStream inputStream = null;){
            inputStream = new BufferedInputStream(new FileInputStream(this.binaryFile));
            byte[] bytes = new byte[(int)this.binaryFile.length()];
            inputStream.read(bytes, 0, bytes.length);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public String toString() {
        return "Binary [namespaceId=" + this.namespaceId + ", publication id=" + this.publicationId + ", id=" + this.id + ", file=" + this.binaryFile.getAbsolutePath() + "]";
    }

    @Override
    public long getDataSize() {
        return this.binaryFile.length();
    }
}

