/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.meta;

import com.tridion.taxonomies.Keyword;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Category {
    private String name;
    private List<Keyword> keywords;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getKeywords() {
        List<String> keywordNames = this.keywords.stream().map(Keyword::getKeywordName).collect(Collectors.toList());
        return keywordNames.toArray(new String[keywordNames.size()]);
    }

    public Keyword[] getKeywordList() {
        return this.keywords.toArray(new Keyword[this.keywords.size()]);
    }

    public void setKeywords(String[] keywordNames) {
        this.keywords = new ArrayList<Keyword>();
        for (String keywordName : keywordNames) {
            this.keywords.add(new Keyword("", "", keywordName));
        }
    }

    public void setKeywords(Keyword[] keywords) {
        this.keywords = new ArrayList<Keyword>();
        Collections.addAll(this.keywords, keywords);
    }

    public void addKeyword(Keyword keyword) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<Keyword>();
        }
        this.keywords.add(keyword);
    }
}

