/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.meta;

import com.tridion.meta.NameValuePair;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMeta
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(CustomMeta.class);
    private static final long serialVersionUID = -570884940396252111L;
    private static final Pattern DATE_PATTERN = Pattern.compile("^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}\\.\\d+$");
    private static final ThreadLocal<SimpleDateFormat> SIMPLE_DATE_FORMAT_POOL = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
    private final String name;
    private final Map<String, NameValuePair> nameValues;
    private final Map<String, CustomMeta> children;

    public CustomMeta(String name, Map<String, NameValuePair> nameValues, Map<String, CustomMeta> children) {
        this.name = name;
        this.nameValues = nameValues;
        this.children = Objects.requireNonNullElse(children, Collections.emptyMap());
    }

    public boolean isEmpty() {
        return this.nameValues.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, CustomMeta> getChildren() {
        return this.children;
    }

    public Map<String, NameValuePair> getNameValues() {
        return this.nameValues.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.handleTypeInNameValuePair((NameValuePair)entry.getValue())));
    }

    @Deprecated
    public Object getValue(String key) {
        if (this.nameValues.containsKey(key)) {
            NameValuePair nameValuePair = this.nameValues.get(key);
            return this.handleObjectType(nameValuePair.getValue());
        }
        return null;
    }

    public Object getFirstValue(String key) {
        if (this.nameValues.containsKey(key)) {
            NameValuePair nameValuePair = this.nameValues.get(key);
            return this.handleObjectType(nameValuePair.getFirstValue());
        }
        return null;
    }

    public CustomMeta getChild(String key) {
        if (this.children.containsKey(key)) {
            return this.children.get(key);
        }
        return null;
    }

    private Date parseObjectAsDate(String value) throws ParseException {
        return SIMPLE_DATE_FORMAT_POOL.get().parse(value);
    }

    private Object handleObjectType(Object value) {
        String stringValue;
        if (value instanceof ZonedDateTime) {
            return Date.from(((ZonedDateTime)value).toInstant());
        }
        if (value instanceof BigDecimal) {
            return Float.valueOf(((BigDecimal)value).floatValue());
        }
        if (value instanceof Double) {
            return Float.valueOf(((Double)value).floatValue());
        }
        if (value instanceof String && DATE_PATTERN.matcher(stringValue = (String)value).matches()) {
            try {
                return this.parseObjectAsDate(stringValue);
            }
            catch (ParseException e) {
                LOG.debug("Was not able to parse value: {} into Date.", (Object)stringValue);
            }
        }
        return value;
    }

    private NameValuePair handleTypeInNameValuePair(NameValuePair nameValuePair) {
        return new NameValuePair(nameValuePair.getName(), nameValuePair.getMetadataType(), nameValuePair.getMultipleValues().stream().map(this::handleObjectType).collect(Collectors.toList()));
    }
}

