/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.storage.BaseEntityImpl;
import com.tridion.storage.entities.BinaryContentEntity;
import java.util.Arrays;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BINARY_CONTENT")
public class BinaryContent
extends BaseEntityImpl
implements BinaryContentEntity {
    private static final int THREE = 3;
    private static final int HASH_CODE_INT = 31;
    private int namespaceId;
    private int publicationId;
    private int binaryId;
    private String variantId;
    private byte[] content;
    private Long entityId;

    public BinaryContent() {
        this.setContent(null);
    }

    public BinaryContent(int namespaceId, int publicationId, int binaryId, String variantId, byte[] content) {
        this.namespaceId = namespaceId;
        this.publicationId = publicationId;
        this.binaryId = binaryId;
        this.variantId = variantId;
        this.setContent(content);
    }

    @Id
    @Column(name="BINARY_CONTENT_KEY", updatable=false)
    @SequenceGenerator(name="SEQ_BINARY_CONTENT_KEY", sequenceName="SEQ_BINARY_CONTENT_KEY")
    @GeneratedValue(generator="SEQ_BINARY_CONTENT_KEY")
    public Long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    @Override
    @Transient
    public Object getPK() {
        return this.entityId;
    }

    @Override
    @Column(name="NAMESPACE_ID", updatable=false, nullable=false)
    public int getNamespaceId() {
        return this.namespaceId;
    }

    @Override
    public void setNamespaceId(int namespaceId) {
        this.namespaceId = namespaceId;
    }

    @Override
    @Column(name="PUBLICATION_ID", updatable=false, nullable=false)
    public int getPublicationId() {
        return this.publicationId;
    }

    @Override
    public void setPublicationId(int publicationId) {
        this.publicationId = publicationId;
    }

    @Override
    @Column(name="BINARY_ID", updatable=false, nullable=false)
    public int getBinaryId() {
        return this.binaryId;
    }

    @Override
    public void setBinaryId(int binaryId) {
        this.binaryId = binaryId;
    }

    @Override
    @Column(name="VARIANT_ID", updatable=false, nullable=false)
    public String getVariantId() {
        return this.variantId;
    }

    @Override
    public void setVariantId(String variantId) {
        this.variantId = variantId;
    }

    @Override
    @Column(name="CONTENT")
    @Lob
    @Type(type="com.tridion.storage.hibernatetype.NotLoggablePrimitiveByteArrayBlobType")
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public void setContent(byte[] content) {
        this.content = content == null || content.length == 0 ? new byte[1] : content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryContent that = (BinaryContent)o;
        return this.namespaceId == that.namespaceId && this.publicationId == that.publicationId && this.binaryId == that.binaryId && Objects.equals(this.variantId, that.variantId) && Arrays.equals(this.content, that.content) && Objects.equals(this.entityId, that.entityId);
    }

    public int hashCode() {
        int result = Objects.hash(this.namespaceId, this.publicationId, this.binaryId, this.variantId, this.entityId);
        result = 31 * result + Arrays.hashCode(this.content);
        return result;
    }

    public String toString() {
        return "BinaryContent{namespaceId=" + this.namespaceId + ", publicationId=" + this.publicationId + ", binaryId=" + this.binaryId + ", variantId='" + this.variantId + "', content=" + Arrays.toString(this.content) + ", entityId=" + this.entityId + "}";
    }
}

