/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.storage.BaseEntityImpl;
import com.tridion.storage.BinaryVariant;
import com.tridion.storage.ComponentMeta;
import com.tridion.storage.entities.BinaryMetaEntity;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="`BINARY`")
public class BinaryMeta
extends BaseEntityImpl
implements BinaryMetaEntity {
    private Long entityId;
    private int namespaceId;
    private int itemId;
    private int publicationId;
    private Long multimediaMetaId;
    private String binaryType;
    private ComponentMeta multimediaMeta;
    private List<BinaryVariant> binaryVariants = new ArrayList<BinaryVariant>();
    private static final int THREE = 3;
    private static final int TWO = 2;

    @Id
    @Column(name="BINARY_KEY", updatable=false)
    @SequenceGenerator(name="SEQ_BINARY_KEY", sequenceName="SEQ_BINARY_KEY")
    @GeneratedValue(generator="SEQ_BINARY_KEY")
    public Long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    @Override
    @Transient
    public Object getPK() {
        return this.entityId;
    }

    @Override
    @Column(name="NAMESPACE_ID", nullable=false)
    public int getNamespaceId() {
        return this.namespaceId;
    }

    @Override
    public void setNamespaceId(int namespaceId) {
        this.namespaceId = namespaceId;
    }

    @Override
    @Column(name="TYPE")
    public String getBinaryType() {
        return this.binaryType;
    }

    @Override
    public void setBinaryType(String binaryType) {
        this.binaryType = binaryType;
    }

    @Override
    @Column(name="ITEM_REFERENCE_ID", nullable=false)
    public int getItemId() {
        return this.itemId;
    }

    @Override
    public void setItemId(int itemId) {
        this.itemId = itemId;
    }

    @Override
    @Column(name="PUBLICATION_ID", nullable=false)
    public int getPublicationId() {
        return this.publicationId;
    }

    @Override
    public void setPublicationId(int publicationId) {
        this.publicationId = publicationId;
    }

    @Override
    @OneToMany(mappedBy="binaryMeta")
    public List<BinaryVariant> getBinaryVariants() {
        return this.binaryVariants;
    }

    @Column(name="ITEMS_KEY")
    public Long getMultimediaMetaId() {
        return this.multimediaMetaId;
    }

    public void setMultimediaMetaId(Long multimediaMetaId) {
        this.multimediaMetaId = multimediaMetaId;
    }

    @Override
    public void setBinaryVariants(List<BinaryVariant> binaryVariants) {
        this.binaryVariants = new ArrayList<BinaryVariant>(binaryVariants);
    }

    @Override
    @OneToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="ITEMS_KEY", referencedColumnName="ITEMS_KEY", insertable=false, updatable=false)
    public ComponentMeta getMultimediaMeta() {
        return this.multimediaMeta;
    }

    @Override
    public void setMultimediaMeta(ComponentMeta multimediaMeta) {
        this.multimediaMeta = multimediaMeta;
    }

    public String toString() {
        return "BinaryMeta{entityId=" + this.entityId + ", namespaceId=" + this.namespaceId + ", itemId=" + this.itemId + ", publicationId=" + this.publicationId + ", multimediaMetaId=" + this.multimediaMetaId + ", binaryType='" + this.binaryType + "', multimediaMeta=" + this.multimediaMeta + ", binaryVariants=" + this.binaryVariants + "}";
    }
}

