/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.storage.BaseEntityImpl;
import com.tridion.storage.BinaryContent;
import com.tridion.storage.BinaryMeta;
import com.tridion.storage.entities.BinaryVariantEntity;
import com.tridion.util.BinaryVariantUtils;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="BINARYVARIANTS")
public class BinaryVariant
extends BaseEntityImpl
implements BinaryVariantEntity {
    private static final int THREE = 3;
    private Long entityId;
    private String description;
    private String path;
    private String url;
    private boolean isComponent;
    private String structureGroupId;
    private String binaryType;
    private int namespaceId;
    private int publicationId;
    private int binaryId;
    private String variantId;
    private Long binaryMetaId;
    private BinaryMeta binaryMeta;
    private Long binaryContentId;
    private BinaryContent binaryContent;

    @Id
    @Column(name="BINARYVARIANTS_KEY", updatable=false)
    @SequenceGenerator(name="SEQ_BINARYVARIANTS_KEY", sequenceName="SEQ_BINARYVARIANTS_KEY")
    @GeneratedValue(generator="SEQ_BINARYVARIANTS_KEY")
    public Long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    @Override
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="BINARY_KEY", referencedColumnName="BINARY_KEY", insertable=false, updatable=false)
    public BinaryMeta getBinaryMeta() {
        return this.binaryMeta;
    }

    @Column(name="BINARY_KEY", nullable=false)
    public Long getBinaryMetaId() {
        return this.binaryMetaId;
    }

    public void setBinaryMetaId(Long binaryMetaId) {
        this.binaryMetaId = binaryMetaId;
    }

    @Override
    public void setBinaryMeta(BinaryMeta binaryMeta) {
        this.binaryMeta = binaryMeta;
    }

    @Override
    @Column(name="DESCRIPTION")
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @Column(name="PATH")
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    @Column(name="URL")
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    @Column(name="IS_COMPONENT")
    public boolean isComponent() {
        return this.isComponent;
    }

    @Override
    public void setComponent(boolean component) {
        this.isComponent = component;
    }

    @Override
    @Column(name="TYPE")
    public String getBinaryType() {
        return this.binaryType;
    }

    @Override
    public void setBinaryType(String binaryType) {
        this.binaryType = binaryType;
    }

    @Override
    @Transient
    public Object getPK() {
        return this.entityId;
    }

    @Override
    @Transient
    public String getStructureGroupId() {
        return this.structureGroupId;
    }

    @Override
    public void setStructureGroupId(String structureGroupId) {
        this.structureGroupId = structureGroupId;
    }

    @Column(name="NAMESPACE_ID", nullable=false, updatable=false)
    public int getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(int namespaceId) {
        this.namespaceId = namespaceId;
    }

    @Override
    @Column(name="PUBLICATION_ID", nullable=false, updatable=false)
    public int getPublicationId() {
        return this.publicationId;
    }

    public void setPublicationId(int publicationId) {
        this.publicationId = publicationId;
    }

    @Override
    @Column(name="BINARY_ID", nullable=false, updatable=false)
    public int getBinaryId() {
        return this.binaryId;
    }

    public void setBinaryId(int binaryId) {
        this.binaryId = binaryId;
    }

    @Override
    @Column(name="VARIANT_ID", nullable=false, updatable=false)
    public String getVariantId() {
        return this.variantId;
    }

    public void setVariantId(String variantId) {
        this.variantId = variantId;
    }

    @Column(name="BINARY_CONTENT_KEY")
    public Long getBinaryContentId() {
        return this.binaryContentId;
    }

    public void setBinaryContentId(Long binaryContentId) {
        this.binaryContentId = binaryContentId;
    }

    @OneToOne(fetch=FetchType.LAZY)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="BINARY_CONTENT_KEY", referencedColumnName="BINARY_CONTENT_KEY", insertable=false, updatable=false)
    public BinaryContent getBinaryContent() {
        return this.binaryContent;
    }

    public void setBinaryContent(BinaryContent binaryContent) {
        this.binaryContent = binaryContent;
    }

    @Transient
    public String getNormalizedVariantId() {
        return BinaryVariantUtils.normalizeVariantId((String)this.variantId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryVariant that = (BinaryVariant)o;
        return Objects.equals(this.entityId, that.entityId) && this.namespaceId == that.namespaceId && this.publicationId == that.publicationId && this.binaryId == that.binaryId && Objects.equals(this.variantId, that.variantId);
    }

    public int hashCode() {
        return Objects.hash(this.entityId, this.namespaceId, this.publicationId, this.binaryId, this.variantId);
    }

    public String toString() {
        return "BinaryVariant{entityId=" + this.entityId + ", description='" + this.description + "', path='" + this.path + "', url='" + this.url + "', isComponent=" + this.isComponent + ", structureGroupId='" + this.structureGroupId + "', binaryType='" + this.binaryType + "', namespaceId=" + this.namespaceId + ", publicationId=" + this.publicationId + ", binaryId=" + this.binaryId + ", variantId='" + this.variantId + "', binaryMetaId=" + this.binaryMetaId + "}";
    }
}

