/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.storage.ComponentPresentationMeta;
import com.tridion.storage.ItemMeta;
import com.tridion.storage.PageMeta;
import com.tridion.storage.entities.ComponentMetaEntity;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="COMPONENT")
public class ComponentMeta
extends ItemMeta
implements ComponentMetaEntity {
    private static final int FIVE = 5;
    private Integer schemaId;
    private Integer contentId;
    private boolean isMultimedia;
    private int entityNamespaceId;
    private int entityItemId;
    private int entityPublicationId;
    private List<ComponentPresentationMeta> componentPresentationMetaList;
    private Set<PageMeta> linkedPages = new HashSet<PageMeta>();

    public ComponentMeta() {
        this.setItemSelector("component");
        this.setItemType(16);
        this.isMultimedia = false;
    }

    public ComponentMeta(com.tridion.meta.ComponentMeta componentMeta) {
        super(componentMeta, componentMeta.getCustomMeta(), 16);
        this.setNamespaceId(componentMeta.getNamespaceId());
        this.setItemId(componentMeta.getId());
        this.setPublicationId(componentMeta.getPublicationId());
        this.schemaId = componentMeta.getSchemaId();
        this.setTrustee(componentMeta.getAuthor());
        this.setItemSelector("component");
        this.isMultimedia = componentMeta.isMultimedia();
    }

    public void setEntityNamespaceId(int entityNamespaceId) {
        this.entityNamespaceId = entityNamespaceId;
    }

    public void setEntityItemId(int entityItemId) {
        this.entityItemId = entityItemId;
    }

    public void setEntityPublicationId(int entityPublicationId) {
        this.entityPublicationId = entityPublicationId;
    }

    @Override
    public void setNamespaceId(int namespaceId) {
        super.setNamespaceId(namespaceId);
        this.setEntityNamespaceId(namespaceId);
    }

    @Override
    public void setPublicationId(int publicationId) {
        super.setPublicationId(publicationId);
        this.setEntityPublicationId(publicationId);
    }

    @Override
    public void setItemId(int itemId) {
        super.setItemId(itemId);
        this.setEntityItemId(itemId);
    }

    @Override
    @Column(name="SCHEMA_ID")
    public Integer getSchemaId() {
        return this.schemaId;
    }

    @Override
    public void setSchemaId(Integer schemaId) {
        this.schemaId = schemaId;
    }

    @Override
    @Column(name="IS_MULTIMEDIA")
    public boolean isMultimedia() {
        return this.isMultimedia;
    }

    @Override
    public void setMultimedia(boolean multimedia) {
        this.isMultimedia = multimedia;
    }

    @Column(name="NAMESPACE_ID")
    public int getEntityNamespaceId() {
        return this.entityNamespaceId;
    }

    @Column(name="ITEM_REFERENCE_ID")
    public int getEntityItemId() {
        return this.entityItemId;
    }

    @Column(name="PUBLICATION_ID")
    public int getEntityPublicationId() {
        return this.entityPublicationId;
    }

    @ManyToMany
    @JoinTable(name="PAGE_COMPONENT_LINK", joinColumns={@JoinColumn(name="COMPONENT_ITEMS_KEY")}, inverseJoinColumns={@JoinColumn(name="PAGE_ITEMS_KEY")})
    public Set<PageMeta> getLinkedPages() {
        return this.linkedPages;
    }

    public void setLinkedPages(Set<PageMeta> linkedPages) {
        this.linkedPages = linkedPages;
    }

    public void addLinkedPage(PageMeta linkedPage) {
        this.linkedPages.add(linkedPage);
    }

    @OneToMany(mappedBy="componentMeta")
    public List<ComponentPresentationMeta> getComponentPresentationMetas() {
        return this.componentPresentationMetaList;
    }

    public void setComponentPresentationMetas(List<ComponentPresentationMeta> componentPresentationMetas) {
        this.componentPresentationMetaList = componentPresentationMetas;
    }

    @Column(name="CONTENT_ID")
    public Integer getContentId() {
        return this.contentId;
    }

    public void setContentId(Integer contentId) {
        this.contentId = contentId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComponentMeta)) {
            return false;
        }
        ComponentMeta that = (ComponentMeta)o;
        return super.equals(o) && this.isMultimedia == that.isMultimedia && Objects.equals(this.schemaId, that.schemaId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.schemaId, this.isMultimedia, super.hashCode());
    }

    @Override
    public String toString() {
        return "ComponentMeta{schemaId=" + this.schemaId + ", isMultimedia=" + this.isMultimedia + ", entityNamespaceId=" + this.entityNamespaceId + ", entityItemId=" + this.entityItemId + ", entityPublicationId=" + this.entityPublicationId + "}";
    }
}

