/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.storage.BaseEntityImpl;
import com.tridion.storage.ComponentPresentationMeta;
import com.tridion.storage.entities.ComponentPresentationEntity;
import java.util.Arrays;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="COMPONENT_PRESENTATIONS")
public class ComponentPresentation
extends BaseEntityImpl
implements ComponentPresentationEntity {
    private static final int HASH_CODE_INT = 31;
    private static final int DEFAULT_COLUMN = 10000000;
    private static final int FIVE = 5;
    private Long entityId;
    private int namespaceId;
    private int publicationId;
    private int componentId;
    private int templateId;
    private byte[] content;
    private Integer contentId;
    private Long componentPresentationMetaId;
    private ComponentPresentationMeta componentPresentationMeta;

    public ComponentPresentation() {
        this.setContent(null);
    }

    public ComponentPresentation(int namespaceId, int publicationId, int componentId, int templateId, byte[] content) {
        this.namespaceId = namespaceId;
        this.publicationId = publicationId;
        this.componentId = componentId;
        this.templateId = templateId;
        this.setContent(content);
    }

    @Id
    @Column(name="COMPONENT_PRESENTATIONS_KEY", updatable=false)
    @SequenceGenerator(name="SEQ_CP_KEY", sequenceName="SEQ_CP_KEY")
    @GeneratedValue(generator="SEQ_CP_KEY")
    public Long getEntityId() {
        return this.entityId;
    }

    @Override
    @Transient
    public Object getPK() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    @Override
    @Column(name="NAMESPACE_ID", updatable=false, nullable=false)
    public int getNamespaceId() {
        return this.namespaceId;
    }

    @Override
    public void setNamespaceId(int namespaceId) {
        this.namespaceId = namespaceId;
    }

    @Override
    @Column(name="PUBLICATION_ID", updatable=false, nullable=false)
    public int getPublicationId() {
        return this.publicationId;
    }

    @Override
    public void setPublicationId(int publicationId) {
        this.publicationId = publicationId;
    }

    @Override
    @Column(name="COMPONENT_ID", updatable=false, nullable=false)
    public int getComponentId() {
        return this.componentId;
    }

    @Override
    public void setComponentId(int componentId) {
        this.componentId = componentId;
    }

    @Override
    @Column(name="TEMPLATE_ID", updatable=false, nullable=false)
    public int getTemplateId() {
        return this.templateId;
    }

    @Override
    public void setTemplateId(int templateId) {
        this.templateId = templateId;
    }

    @Override
    @Column(name="CONTENT", length=10000000)
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public void setContent(byte[] content) {
        this.content = content == null || content.length == 0 ? new byte[1] : content;
    }

    @Override
    @Column(name="CONTENT_ID")
    public Integer getContentId() {
        return this.contentId;
    }

    @Override
    public void setContentId(Integer contentId) {
        this.contentId = contentId;
    }

    @Column(name="COMPONENT_PRES_META_DATA_KEY")
    public Long getComponentPresentationMetaId() {
        return this.componentPresentationMetaId;
    }

    public void setComponentPresentationMetaId(Long componentPresentationMetaId) {
        this.componentPresentationMetaId = componentPresentationMetaId;
    }

    @OneToOne
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="COMPONENT_PRES_META_DATA_KEY", referencedColumnName="COMPONENT_PRES_META_DATA_KEY", insertable=false, updatable=false)
    public ComponentPresentationMeta getComponentPresentationMeta() {
        return this.componentPresentationMeta;
    }

    public void setComponentPresentationMeta(ComponentPresentationMeta componentPresentationMeta) {
        this.componentPresentationMeta = componentPresentationMeta;
    }

    public String toString() {
        return "ComponentPresentation{entityId=" + this.entityId + ", namespaceId=" + this.namespaceId + ", publicationId=" + this.publicationId + ", componentId=" + this.componentId + ", templateId=" + this.templateId + ", contentId=" + this.contentId + ", componentPresentationMetaId=" + this.componentPresentationMetaId + "} ";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentPresentation that = (ComponentPresentation)o;
        return this.namespaceId == that.namespaceId && this.publicationId == that.publicationId && this.componentId == that.componentId && this.templateId == that.templateId && Objects.equals(this.entityId, that.entityId) && Arrays.equals(this.content, that.content) && Objects.equals(this.contentId, that.contentId);
    }

    public int hashCode() {
        int result = Objects.hash(this.entityId, this.namespaceId, this.publicationId, this.componentId, this.templateId, this.contentId);
        result = 31 * result + Arrays.hashCode(this.content);
        return result;
    }
}

