/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.storage.BaseEntityImpl;
import com.tridion.storage.entities.ContentEntity;
import com.tridion.util.StringUtils;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="CONTENT")
public class Content
extends BaseEntityImpl
implements ContentEntity {
    private int itemReferenceId;
    private int namespaceId;
    private int publicationId;
    private int contentId;
    private String contentType;
    private String contentData;
    private String charSet;
    private static final int LENGTH = 1000000000;
    private static final int FOUR = 4;

    public Content() {
        this.setContentData(null);
    }

    @Id
    @SequenceGenerator(name="SEQ_CONTENT_ITEM_REF_ID", sequenceName="SEQ_CONTENT_ITEM_REF_ID")
    @GeneratedValue(generator="SEQ_CONTENT_ITEM_REF_ID")
    @Column(name="CONTENT_ID")
    public int getContentId() {
        return this.contentId;
    }

    @Override
    @Column(name="ITEM_REFERENCE_ID")
    public int getItemReferenceId() {
        return this.itemReferenceId;
    }

    @Override
    public void setItemReferenceId(int itemReferenceId) {
        this.itemReferenceId = itemReferenceId;
    }

    @Override
    @Column(name="NAMESPACE_ID")
    public int getNamespaceId() {
        return this.namespaceId;
    }

    @Override
    public void setNamespaceId(int namespaceId) {
        this.namespaceId = namespaceId;
    }

    @Override
    @Column(name="PUBLICATION_ID")
    public int getPublicationId() {
        return this.publicationId;
    }

    @Override
    public void setPublicationId(int publicationId) {
        this.publicationId = publicationId;
    }

    @Override
    @Column(name="CONTENT_TYPE")
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    @Column(name="CONTENT_DATA", length=1000000000)
    public String getContentData() {
        return this.contentData;
    }

    @Override
    public void setContentData(String content) {
        this.contentData = StringUtils.isEmpty((String)content) ? " " : content;
    }

    @Override
    @Column(name="CHARSET")
    public String getCharSet() {
        return this.charSet;
    }

    @Override
    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    public void setContentId(int contentId) {
        this.contentId = contentId;
    }

    @Override
    @Transient
    public Object getPK() {
        return this.contentId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Content{");
        sb.append("contentId=").append(this.contentId);
        sb.append(", itemReferenceId=").append(this.itemReferenceId);
        sb.append(", namespaceId=").append(this.namespaceId);
        sb.append(", publicationId=").append(this.publicationId);
        sb.append(", contentType='").append(this.contentType).append('\'');
        sb.append(", contentData='").append(this.contentData).append('\'');
        sb.append(", charSet='").append(this.charSet).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Content content = (Content)o;
        return this.itemReferenceId == content.itemReferenceId && this.namespaceId == content.namespaceId && this.publicationId == content.publicationId && Objects.equals(this.contentType, content.contentType) && Objects.equals(this.charSet, content.charSet) && Objects.equals(this.contentData.replace("\r\n", "\n"), content.contentData.replace("\r\n", "\n"));
    }

    public int hashCode() {
        return Objects.hash(this.itemReferenceId, this.namespaceId, this.publicationId, this.contentType, this.contentData, this.charSet);
    }
}

