/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.broker.querying.MetadataType;
import com.tridion.storage.BaseEntityImpl;
import com.tridion.storage.ItemMeta;
import com.tridion.storage.entities.CustomMetaValueEntity;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CUSTOM_META")
public class CustomMetaValue
extends BaseEntityImpl
implements CustomMetaValueEntity {
    private static final int KEY_TYPE_FLOAT = 3;
    private static final int KEY_TYPE_DATE = 2;
    private static final int KEY_TYPE_STRING = 1;
    private static final int THREE = 3;
    private static final int SIX = 6;
    private static final int LOB_SIZE = 10000000;
    private static final int KEY_STRING_VALUE_SIZE = 3400;
    private int customMetaValueId;
    private int namespaceId;
    private int publicationId;
    private int itemId;
    private String keyName;
    private int itemType;
    private ItemMeta relatedItem;
    private String stringValue;
    private String stringLobValue;
    private Float floatValue;
    private Date dateValue;
    private int keyType;
    private Long relatedItemId;
    private Integer schemaId;
    private String path;

    public CustomMetaValue() {
    }

    public CustomMetaValue(String value, boolean storeAsLob) {
        if (storeAsLob) {
            this.stringLobValue = value;
        } else {
            this.stringValue = value;
        }
        this.keyType = 1;
    }

    public CustomMetaValue(Float value) {
        this.floatValue = value;
        this.keyType = 3;
    }

    public CustomMetaValue(Date value) {
        this.dateValue = value;
        this.keyType = 2;
    }

    @Override
    @Id
    @Column(name="CUSTOM_META_VALUE_ID")
    @SequenceGenerator(name="SEQ_CUSTOM_META_VALUE", sequenceName="SEQ_CUSTOM_META_VALUE")
    @GeneratedValue(generator="SEQ_CUSTOM_META_VALUE")
    public int getCustomMetaValueId() {
        return this.customMetaValueId;
    }

    @Override
    public void setCustomMetaValueId(int customMetaValueId) {
        this.customMetaValueId = customMetaValueId;
    }

    @Override
    @Column(name="NAMESPACE_ID")
    public int getNamespaceId() {
        return this.namespaceId;
    }

    @Override
    public void setNamespaceId(int namespaceId) {
        this.namespaceId = namespaceId;
    }

    @Override
    @Column(name="PUBLICATION_ID")
    public int getPublicationId() {
        return this.publicationId;
    }

    @Override
    public void setPublicationId(int publicationId) {
        this.publicationId = publicationId;
    }

    @Override
    @Column(name="ITEM_ID")
    public int getItemId() {
        return this.itemId;
    }

    @Override
    public void setItemId(int itemId) {
        this.itemId = itemId;
    }

    @Override
    @Column(name="KEY_NAME")
    public String getKeyName() {
        return this.keyName;
    }

    @Override
    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    @Override
    @Column(name="ITEM_TYPE")
    public int getItemType() {
        return this.itemType;
    }

    @Override
    public void setItemType(int itemType) {
        this.itemType = itemType;
    }

    @Override
    @Column(name="KEY_TYPE")
    public int getKeyType() {
        return this.keyType;
    }

    @Override
    public void setKeyType(int keyType) {
        this.keyType = keyType;
    }

    @Column(name="ITEMS_KEY")
    public Long getRelatedItemId() {
        return this.relatedItemId;
    }

    public void setRelatedItemId(Long relatedItemId) {
        this.relatedItemId = relatedItemId;
    }

    @Override
    @Column(name="KEY_STRING_VALUE", length=3400)
    public String getStringValue() {
        return this.stringValue;
    }

    @Override
    public void setStringValue(String value) {
        this.stringValue = value;
    }

    @Override
    @Lob
    @Type(type="org.hibernate.type.TextType")
    @Column(name="KEY_STRING_LOB_VALUE", length=10000000)
    public String getStringLobValue() {
        return this.stringLobValue;
    }

    @Override
    public void setStringLobValue(String stringLobValue) {
        this.stringLobValue = stringLobValue;
    }

    @Override
    @Column(name="KEY_FLOAT_VALUE")
    public Float getFloatValue() {
        return this.floatValue;
    }

    @Override
    public void setFloatValue(Float value) {
        this.floatValue = value;
    }

    @Override
    @Column(name="KEY_DATE_VALUE")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDateValue() {
        return this.dateValue;
    }

    @Override
    public void setDateValue(Date value) {
        this.dateValue = value;
    }

    @Override
    @Column(name="SCHEMA_ID")
    public Integer getSchemaId() {
        return this.schemaId;
    }

    @Override
    public void setSchemaId(Integer schemaId) {
        this.schemaId = schemaId;
    }

    @Override
    @Column(name="PATH")
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    @Transient
    public MetadataType getMetadataType() {
        if (this.isKeyTypeFloat()) {
            return MetadataType.FLOAT;
        }
        if (this.isKeyTypeDate()) {
            return MetadataType.DATE;
        }
        return MetadataType.STRING;
    }

    @Override
    @JoinColumn(name="ITEMS_KEY", referencedColumnName="ITEMS_KEY", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    public ItemMeta getRelatedItem() {
        return this.relatedItem;
    }

    @Override
    public void setRelatedItem(ItemMeta relatedItem) {
        this.relatedItem = relatedItem;
    }

    @Override
    @Transient
    public Object getPK() {
        return this.getCustomMetaValueId();
    }

    @Override
    @Transient
    public Object getValue() {
        if (this.isKeyTypeFloat()) {
            return this.floatValue;
        }
        if (this.isKeyTypeDate()) {
            return this.dateValue;
        }
        if (this.isKeyTypeString()) {
            return this.getStoredStringValue();
        }
        return null;
    }

    public String toString() {
        if (this.isKeyTypeFloat()) {
            return this.floatValue.toString();
        }
        if (this.isKeyTypeDate()) {
            return this.dateValue.toString();
        }
        if (this.isKeyTypeString()) {
            return this.getStoredStringValue();
        }
        return "";
    }

    @Transient
    private String getStoredStringValue() {
        return this.stringValue == null ? this.stringLobValue : this.stringValue;
    }

    @Transient
    private boolean isKeyTypeString() {
        return this.keyType == 1;
    }

    @Transient
    private boolean isKeyTypeDate() {
        return this.keyType == 2;
    }

    @Transient
    private boolean isKeyTypeFloat() {
        return this.keyType == 3;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomMetaValue)) {
            return false;
        }
        CustomMetaValue that = (CustomMetaValue)o;
        return Objects.equals(this.namespaceId, that.namespaceId) && Objects.equals(this.publicationId, that.publicationId) && Objects.equals(this.itemId, that.itemId) && Objects.equals(this.itemType, that.itemType) && Objects.equals(this.keyType, that.keyType) && Objects.equals(this.keyName, that.keyName) && Objects.equals(this.relatedItemId, that.relatedItemId) && Objects.equals(this.schemaId, that.schemaId) && Objects.equals(this.path, that.path) && Objects.equals(this.dateValue, that.dateValue) && Objects.equals(this.floatValue, that.floatValue) && Objects.equals(this.stringValue, that.stringValue) && Objects.equals(this.stringLobValue, that.stringLobValue);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceId, this.publicationId, this.itemId, this.itemType, this.keyType, this.keyName, this.relatedItemId, this.schemaId, this.path, this.dateValue, this.floatValue, this.stringValue);
    }
}

