/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.storage.BaseEntityImpl;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ECL_SCHEMAS")
public class ExternalSchema
extends BaseEntityImpl {
    private static final int LENGTH = 10000000;
    private static final int TWO = 2;
    @Id
    @SequenceGenerator(name="SEQ_ECL_SCHEMA_ID", sequenceName="SEQ_ECL_SCHEMA_ID")
    @GeneratedValue(generator="SEQ_ECL_SCHEMA_ID")
    @Column(name="SCHEMA_ID")
    private Long schemaId;
    @Column(name="NAMESPACE_ID")
    private int namespaceId;
    @Column(name="PUBLICATION_ID")
    private int publicationId;
    @Column(name="CONTENT", length=10000000)
    private String schemaContent;
    @Column(name="TITLE")
    private String title = "Schema-Title";
    @Column(name="ECL_SCHEMA_ID")
    private String eclSchemaId;

    @Override
    @Transient
    public Object getPK() {
        return this.schemaId;
    }

    public int getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(int namespaceId) {
        this.namespaceId = namespaceId;
    }

    public int getPublicationId() {
        return this.publicationId;
    }

    public void setPublicationId(int publicationId) {
        this.publicationId = publicationId;
    }

    public Long getSchemaId() {
        return this.schemaId;
    }

    public void setSchemaId(Long schemaId) {
        this.schemaId = schemaId;
    }

    public String getSchemaContent() {
        return this.schemaContent;
    }

    public void setSchemaContent(String schemaContent) {
        this.schemaContent = schemaContent;
    }

    public String getEclSchemaId() {
        return this.eclSchemaId;
    }

    public void setEclSchemaId(String eclSchemaId) {
        this.eclSchemaId = eclSchemaId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ExternalSchema{");
        sb.append("namespaceId=").append(this.namespaceId);
        sb.append(", publicationId=").append(this.publicationId);
        sb.append(", schemaId=").append(this.schemaId);
        sb.append(", schemaContent='").append(this.schemaContent).append('\'');
        sb.append(", title='").append(this.title).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalSchema schema = (ExternalSchema)o;
        return this.namespaceId == schema.namespaceId && this.publicationId == schema.publicationId && Objects.equals(this.schemaId, schema.schemaId) && Objects.equals(this.schemaContent, schema.schemaContent) && Objects.equals(this.title, schema.title);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceId, this.publicationId, this.schemaId, this.schemaContent, this.title);
    }
}

