/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.api.ItemMetaBase;
import com.tridion.broker.querying.MetadataType;
import com.tridion.meta.Category;
import com.tridion.meta.CustomMeta;
import com.tridion.meta.Item;
import com.tridion.meta.NameValuePair;
import com.tridion.storage.BaseEntityImpl;
import com.tridion.storage.CustomMetaValue;
import com.tridion.storage.RelatedKeyword;
import com.tridion.storage.StorageUtils;
import com.tridion.storage.entities.ItemMetaEntity;
import com.tridion.taxonomies.Keyword;
import com.tridion.util.CMURI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="ITEMS")
public class ItemMeta
extends BaseEntityImpl
implements ItemMetaBase,
ItemMetaEntity {
    private static final Logger LOG = LoggerFactory.getLogger(ItemMeta.class);
    private Long entityId;
    private int namespaceId;
    private int itemId;
    private int publicationId;
    private Integer majorVersion;
    private Integer minorVersion;
    private Integer owningPublication;
    private int itemType;
    private String itemSelector;
    private String title;
    private Date creationDate;
    private Date initialPublishDate;
    private Date lastPublishDate;
    private String trustee = "unknown";
    private Date modificationDate;
    private List<CustomMetaValue> customMetaValues = new ArrayList<CustomMetaValue>();
    private List<RelatedKeyword> relatedKeywords = new ArrayList<RelatedKeyword>();
    private static final int TWO = 2;
    private static final int FOUR = 4;
    private static final int SEVEN = 7;

    public ItemMeta() {
        this.majorVersion = 0;
        this.minorVersion = 0;
        this.owningPublication = 0;
        this.creationDate = Calendar.getInstance().getTime();
        this.initialPublishDate = Calendar.getInstance().getTime();
        this.lastPublishDate = Calendar.getInstance().getTime();
        this.modificationDate = Calendar.getInstance().getTime();
    }

    public ItemMeta(Item item, CustomMeta customMeta, int itemType) {
        this.namespaceId = item.getNamespaceId();
        this.itemId = item.getId();
        this.publicationId = item.getPublicationId();
        this.majorVersion = item.getMajorVersion();
        this.minorVersion = item.getMinorVersion();
        this.owningPublication = item.getOwningPublicationId();
        this.title = item.getTitle();
        this.creationDate = item.getCreationDate();
        this.initialPublishDate = item.getInitialPublicationDate();
        this.lastPublishDate = item.getLastPublicationDate();
        this.modificationDate = item.getModificationDate();
        this.itemType = itemType;
        if (customMeta != null) {
            this.setCustomMeta(customMeta);
        }
        if (item.getCategories() != null) {
            this.setRelatedKeywords(item.getCategories());
        }
    }

    @Override
    public void setCustomMeta(CustomMeta customMeta) {
        this.customMetaValues = new ArrayList<CustomMetaValue>();
        Map<String, NameValuePair> nameValuePairs = customMeta.getNameValues();
        for (Map.Entry<String, NameValuePair> entry : nameValuePairs.entrySet()) {
            NameValuePair valuePair = entry.getValue();
            for (Object obj : valuePair.getMultipleValues()) {
                CustomMetaValue metaValue = switch (valuePair.getMetadataType()) {
                    case MetadataType.DATE -> new CustomMetaValue((Date)obj);
                    case MetadataType.FLOAT -> new CustomMetaValue((Float)obj);
                    default -> new CustomMetaValue((String)obj, StorageUtils.shouldStoreCustomMetaValueAsLob((String)obj));
                };
                metaValue.setNamespaceId(this.namespaceId);
                metaValue.setItemId(this.itemId);
                metaValue.setItemType(this.itemType);
                metaValue.setPublicationId(this.publicationId);
                metaValue.setKeyName(valuePair.getName());
                this.customMetaValues.add(metaValue);
            }
        }
    }

    @Override
    @Transient
    public Object getPK() {
        return this.entityId;
    }

    @Id
    @Column(name="ITEMS_KEY", updatable=false)
    @SequenceGenerator(name="SEQ_ITEMS_KEY", sequenceName="SEQ_ITEMS_KEY")
    @GeneratedValue(generator="SEQ_ITEMS_KEY")
    public Long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    @Override
    @Column(name="NAMESPACE_ID")
    public int getNamespaceId() {
        return this.namespaceId;
    }

    @Override
    public void setNamespaceId(int namespaceId) {
        this.namespaceId = namespaceId;
    }

    @Override
    @Column(name="PUBLICATION_ID")
    public int getPublicationId() {
        return this.publicationId;
    }

    @Override
    @Column(name="ITEM_REFERENCE_ID")
    public int getItemId() {
        return this.itemId;
    }

    @Override
    public void setItemId(int itemId) {
        this.itemId = itemId;
    }

    @Override
    public void setPublicationId(int publicationId) {
        this.publicationId = publicationId;
    }

    @Override
    @Column(nullable=true, name="MAJOR_VERSION")
    public Integer getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public void setMajorVersion(Integer majorVersion) {
        this.majorVersion = majorVersion;
    }

    @Override
    @Column(nullable=true, name="MINOR_VERSION")
    public Integer getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public void setMinorVersion(Integer minorVersion) {
        this.minorVersion = minorVersion;
    }

    @Override
    @Column(nullable=true, name="OWNING_PUBLICATION_ID")
    public Integer getOwningPublication() {
        return this.owningPublication;
    }

    @Override
    public void setOwningPublication(Integer owningPublication) {
        this.owningPublication = owningPublication;
    }

    @Override
    @Column(name="ITEM_TYPE")
    public int getItemType() {
        return this.itemType;
    }

    @Override
    public void setItemType(int itemType) {
        this.itemType = itemType;
    }

    @Override
    @Column(name="TITLE")
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @Column(nullable=true, name="CREATION_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    @Column(nullable=true, name="INITIAL_PUBLICATION_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getInitialPublishDate() {
        return this.initialPublishDate;
    }

    @Override
    public void setInitialPublishDate(Date initialPublishDate) {
        this.initialPublishDate = initialPublishDate;
    }

    @Override
    @Column(nullable=true, name="LAST_PUBLISHED_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getLastPublishDate() {
        return this.lastPublishDate;
    }

    @Override
    public void setLastPublishDate(Date lastPublishDate) {
        this.lastPublishDate = lastPublishDate;
    }

    @Override
    @Column(name="TRUSTEE")
    public String getTrustee() {
        return this.trustee;
    }

    @Override
    public void setTrustee(String trustee) {
        this.trustee = trustee;
    }

    @Override
    @Column(name="ITEM_SELECTOR")
    public String getItemSelector() {
        return this.itemSelector;
    }

    @Override
    public void setItemSelector(String itemSelector) {
        this.itemSelector = itemSelector;
    }

    @Override
    @Column(nullable=true, name="MODIFICATION_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getModificationDate() {
        return this.modificationDate;
    }

    @Override
    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    @Override
    @OneToMany(mappedBy="relatedItem", fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.JOIN)
    public List<CustomMetaValue> getCustomMetaValues() {
        return this.customMetaValues;
    }

    @Override
    public void setCustomMetaValues(List<CustomMetaValue> customMetaValues) {
        this.customMetaValues = customMetaValues;
    }

    @Override
    @OneToMany(mappedBy="relatedItem")
    @Fetch(value=FetchMode.SELECT)
    @OrderBy(value="categoryName ASC, keywordName ASC")
    public List<RelatedKeyword> getRelatedKeywords() {
        return this.relatedKeywords;
    }

    @Override
    public void setRelatedKeywords(List<RelatedKeyword> relatedKeywords) {
        this.relatedKeywords = relatedKeywords;
    }

    @Override
    public void setRelatedKeywords(Category[] categories) {
        this.relatedKeywords = new ArrayList<RelatedKeyword>();
        for (Category category : categories) {
            for (Keyword keyword : category.getKeywordList()) {
                RelatedKeyword relatedKeyword = new RelatedKeyword();
                int keywordId = -1;
                int taxonomyId = -1;
                CMURI keywordURI = new CMURI(null, -1, -1, -1, -1);
                try {
                    keywordURI = new CMURI(keyword.getKeywordURI());
                    CMURI taxonomyURI = new CMURI(keyword.getTaxonomyURI());
                    keywordId = keywordURI.getItemId();
                    taxonomyId = taxonomyURI.getItemId();
                }
                catch (ParseException e) {
                    LOG.warn("Unable to parse the URI's for related keyword, assuming legacy keyword relations. Keyword uri is  {}, taxonomy uri is {}", (Object)keyword.getKeywordURI(), (Object)keyword.getTaxonomyURI());
                }
                relatedKeyword.setKeywordId(keywordId);
                relatedKeyword.setTaxonomyId(taxonomyId);
                relatedKeyword.setCategoryName(category.getName());
                relatedKeyword.setKeywordName(keyword.getKeywordName());
                relatedKeyword.setNamespaceId(this.getNamespaceId());
                relatedKeyword.setPublicationId(this.getPublicationId());
                relatedKeyword.setItemId(this.getItemId());
                relatedKeyword.setTaxFacetType(keywordURI.getItemType());
                this.relatedKeywords.add(relatedKeyword);
            }
        }
    }

    public String toString() {
        return "ItemMeta{entityId=" + this.entityId + ", namespaceId=" + this.namespaceId + ", itemId=" + this.itemId + ", publicationId=" + this.publicationId + ", majorVersion=" + this.majorVersion + ", minorVersion=" + this.minorVersion + ", owningPublication=" + this.owningPublication + ", itemType=" + this.itemType + ", itemSelector='" + this.itemSelector + "', title='" + this.title + "', creationDate=" + this.creationDate + ", initialPublishDate=" + this.initialPublishDate + ", lastPublishDate=" + this.lastPublishDate + ", trustee='" + this.trustee + "', modificationDate=" + this.modificationDate + ", customMetaValues=" + this.customMetaValues + ", relatedKeywords=" + this.relatedKeywords + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemMeta itemMeta = (ItemMeta)o;
        return this.itemId == itemMeta.itemId && this.publicationId == itemMeta.publicationId && this.namespaceId == itemMeta.namespaceId && this.itemType == itemMeta.itemType;
    }

    public int hashCode() {
        return Objects.hash(this.namespaceId, this.itemId, this.publicationId, this.itemType);
    }
}

