/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.storage.TaxonomyItem;
import com.tridion.storage.entities.KeywordEntity;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

@Entity
@DiscriminatorValue(value="Keyword")
public class Keyword
extends TaxonomyItem
implements KeywordEntity {
    private String name;
    private String description;
    private boolean isUsedForIdentification;

    public Keyword() {
    }

    public Keyword(int namespaceId, int publicationId, int taxonomyId) {
        super.setNamespaceId(namespaceId);
        super.setPublicationId(publicationId);
        super.setTaxonomyId(taxonomyId);
    }

    @Override
    @Column(name="FACET_NAME")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Column(name="FACET_DESCRIPTION")
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @Column(name="FACET_ISUSEDFORIDENTIFICATION")
    public boolean isUsedForIdentification() {
        return this.isUsedForIdentification;
    }

    @Override
    public void setUsedForIdentification(boolean usedForIdentification) {
        this.isUsedForIdentification = usedForIdentification;
    }

    @Override
    public String toString() {
        return String.format("Keyword [description=%s, name=%s, getDepth()=%s, getId()=%s, getInternalId()=%s, getItemType()=%s, getKey()=%s, getLeft()=%s, getPK()=%s, getParent()=%s, getNamespaceId=%s, getPublicationId()=%s, getRelatedItems()=%s, getRight()=%s, getTaxonomyId()=%s, isAbstract()=%s, isHasChildren()=%s, isNavigable()=%s]", this.description, this.name, this.getDepth(), this.getId(), this.getInternalId(), this.getItemType(), this.getKey(), this.getLeft(), this.getPK(), this.getParent(), this.getNamespaceId(), this.getPublicationId(), this.getRelatedItems(), this.getRight(), this.getTaxonomyId(), this.isAbstract(), this.isHasChildren(), this.isNavigable());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Keyword keyword = (Keyword)o;
        return this.isUsedForIdentification == keyword.isUsedForIdentification && Objects.equals(this.name, keyword.name) && Objects.equals(this.description, keyword.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.description, this.isUsedForIdentification);
    }
}

