/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.storage.BaseEntityImpl;
import com.tridion.storage.KeywordRelationPK;
import com.tridion.storage.TaxonomyItem;
import com.tridion.storage.entities.KeywordRelationEntity;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="KEYWORD_RELATIONS")
@IdClass(value=KeywordRelationPK.class)
public class KeywordRelation
extends BaseEntityImpl
implements KeywordRelationEntity {
    private TaxonomyItem taxonomyItem;
    private int nodeId;
    private int keywordToId;

    @Override
    @Transient
    public Object getPK() {
        return new KeywordRelationPK(this.nodeId, this.keywordToId);
    }

    @Column(name="NODE")
    @Id
    public int getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    @Id
    @Column(name="KEYWORD_TO")
    public int getKeywordToId() {
        return this.keywordToId;
    }

    public void setKeywordToId(int keywordToId) {
        this.keywordToId = keywordToId;
    }

    @Override
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="NODE", referencedColumnName="NODE_ID", insertable=false, updatable=false)
    public TaxonomyItem getTaxonomyItem() {
        return this.taxonomyItem;
    }

    @Override
    public void setTaxonomyItem(TaxonomyItem taxonomyItem) {
        this.taxonomyItem = taxonomyItem;
    }

    public String toString() {
        return "KeywordRelation{taxonomyItem=" + this.taxonomyItem + ", nodeId=" + this.nodeId + ", keywordToId=" + this.keywordToId + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeywordRelation)) {
            return false;
        }
        KeywordRelation that = (KeywordRelation)o;
        return Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.keywordToId, that.keywordToId);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.keywordToId);
    }
}

