/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.storage.BaseEntityImpl;
import com.tridion.storage.entities.NamespaceEntity;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="NAMESPACE")
public class Namespace
extends BaseEntityImpl
implements NamespaceEntity {
    private int namespaceId;
    private String prefix;

    public Namespace() {
    }

    public Namespace(int namespaceId, String prefix) {
        this.namespaceId = namespaceId;
        this.prefix = prefix;
    }

    @Override
    @Id
    @Column(name="NAMESPACE_ID")
    @SequenceGenerator(name="SEQ_NAMESPACE_VALUE", sequenceName="SEQ_NAMESPACE_VALUE", initialValue=2)
    @GeneratedValue(generator="SEQ_NAMESPACE_VALUE")
    public int getNamespaceId() {
        return this.namespaceId;
    }

    @Override
    public void setNamespaceId(int namespaceId) {
        this.namespaceId = namespaceId;
    }

    @Override
    @Column(name="PREFIX", unique=true)
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Namespace namespace = (Namespace)o;
        return this.namespaceId == namespace.namespaceId && Objects.equals(this.prefix, namespace.prefix);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceId, this.prefix);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Namespace{");
        sb.append("namespaceId=").append(this.namespaceId);
        sb.append(", prefix='").append(this.prefix).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    @Transient
    public Object getPK() {
        return this.namespaceId;
    }
}

