/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.storage.BaseEntityImpl;
import com.tridion.storage.entities.PageContentEntity;
import com.tridion.util.StringUtils;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="PAGE_CONTENT")
public class PageContent
extends BaseEntityImpl
implements PageContentEntity {
    private Long entityId;
    private int namespaceId;
    private int publicationId;
    private int pageId;
    private String content;
    private String charSet;
    private static final int LENGTH = 10000000;
    private static final int THREE = 3;

    public PageContent() {
        this.setContent(null);
    }

    @Id
    @Column(name="PAGE_CONTENT_KEY", updatable=false)
    @SequenceGenerator(name="SEQ_PAGE_CONTENT_KEY", sequenceName="SEQ_PAGE_CONTENT_KEY")
    @GeneratedValue(generator="SEQ_PAGE_CONTENT_KEY")
    public Long getEntityId() {
        return this.entityId;
    }

    @Override
    @Transient
    public Object getPK() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    @Override
    @Column(name="NAMESPACE_ID")
    public int getNamespaceId() {
        return this.namespaceId;
    }

    @Override
    public void setNamespaceId(int namespaceId) {
        this.namespaceId = namespaceId;
    }

    @Override
    @Column(name="PUBLICATION_ID")
    public int getPublicationId() {
        return this.publicationId;
    }

    @Override
    public void setPublicationId(int publicationId) {
        this.publicationId = publicationId;
    }

    @Override
    @Column(name="PAGE_ID")
    public int getPageId() {
        return this.pageId;
    }

    @Override
    public void setPageId(int pageId) {
        this.pageId = pageId;
    }

    @Override
    @Column(name="CONTENT", length=10000000)
    public String getContent() {
        return this.content;
    }

    @Override
    public void setContent(String content) {
        this.content = StringUtils.isEmpty((String)content) ? " " : content;
    }

    @Override
    @Column(name="CHARSET")
    public String getCharSet() {
        return this.charSet;
    }

    @Override
    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    public String toString() {
        return "PageContent{entityId=" + this.entityId + ", namespaceId=" + this.namespaceId + ", publicationId=" + this.publicationId + ", pageId=" + this.pageId + ", content='" + this.content + "', charSet='" + this.charSet + "'}";
    }
}

