/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.storage.ComponentMeta;
import com.tridion.storage.ItemMeta;
import com.tridion.storage.RelatedKeyword;
import com.tridion.storage.entities.PageMetaEntity;
import com.tridion.util.CMURI;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="PAGE")
public class PageMeta
extends ItemMeta
implements PageMetaEntity {
    private static final Logger LOG = LoggerFactory.getLogger(PageMeta.class);
    private String fileName;
    private String url;
    private Integer schemaId;
    private int templateId;
    private Integer contentId;
    private int entityNamespaceId;
    private int entityPublicationId;
    private int entityItemId;
    private Set<ComponentMeta> linkedComponents = new HashSet<ComponentMeta>();

    @Column(name="NAMESPACE_ID")
    public int getEntityNamespaceId() {
        return this.entityNamespaceId;
    }

    @Column(name="ITEM_REFERENCE_ID")
    public int getEntityItemId() {
        return this.entityItemId;
    }

    @Column(name="PUBLICATION_ID")
    public int getEntityPublicationId() {
        return this.entityPublicationId;
    }

    public void setEntityNamespaceId(int entityNamespaceId) {
        this.entityNamespaceId = entityNamespaceId;
        super.setNamespaceId(entityNamespaceId);
    }

    public void setEntityItemId(int entityItemId) {
        this.entityItemId = entityItemId;
        super.setItemId(entityItemId);
    }

    public void setEntityPublicationId(int entityPublicationId) {
        this.entityPublicationId = entityPublicationId;
        super.setPublicationId(entityPublicationId);
    }

    @Override
    public void setNamespaceId(int namespaceId) {
        super.setNamespaceId(namespaceId);
        this.setEntityNamespaceId(namespaceId);
    }

    @Override
    public void setPublicationId(int publicationId) {
        super.setPublicationId(publicationId);
        this.setEntityPublicationId(publicationId);
    }

    @Override
    public void setItemId(int itemId) {
        super.setItemId(itemId);
        this.setEntityItemId(itemId);
    }

    @ManyToMany(mappedBy="linkedPages")
    public Set<ComponentMeta> getLinkedComponents() {
        return this.linkedComponents;
    }

    public void setLinkedComponents(Set<ComponentMeta> linkedComponents) {
        this.linkedComponents = linkedComponents;
    }

    public void addLinkedComponent(ComponentMeta linkedComponent) {
        this.getLinkedComponents().add(linkedComponent);
        linkedComponent.addLinkedPage(this);
    }

    public void removeLinkedComponent(ComponentMeta linkedComponent) {
        this.getLinkedComponents().remove(linkedComponent);
        linkedComponent.getLinkedPages().remove(this);
    }

    public PageMeta() {
        this.setItemSelector("page");
        this.setItemType(64);
    }

    public PageMeta(com.tridion.meta.PageMeta pageMeta) {
        super(pageMeta, pageMeta.getCustomMeta(), 64);
        this.setNamespaceId(pageMeta.getNamespaceId());
        this.setItemId(pageMeta.getId());
        this.setPublicationId(pageMeta.getPublicationId());
        this.schemaId = pageMeta.getSchemaId();
        if (pageMeta.getStructureGroup() != null) {
            this.getRelatedKeywords().add(this.createStructureGroup(pageMeta.getStructureGroup()));
        }
        this.fileName = pageMeta.getPath();
        this.url = pageMeta.getURLPath();
        this.templateId = pageMeta.getTemplateId();
        this.setTrustee("");
        this.setItemSelector("page");
    }

    @Override
    @Column(name="FILENAME")
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    @Column(name="URL")
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    @Column(name="TEMPLATE_ID")
    public int getTemplateId() {
        return this.templateId;
    }

    @Override
    public void setTemplateId(int templateId) {
        this.templateId = templateId;
    }

    @Override
    @Column(name="CONTENT_ID")
    public Integer getContentId() {
        return this.contentId;
    }

    @Override
    public void setContentId(Integer contentId) {
        this.contentId = contentId;
    }

    @Override
    @Column(name="SCHEMA_ID")
    public Integer getSchemaId() {
        return this.schemaId;
    }

    @Override
    public void setSchemaId(Integer schemaId) {
        this.schemaId = schemaId;
    }

    private RelatedKeyword createStructureGroup(String structureGroup) {
        RelatedKeyword relatedKeywordEntity = new RelatedKeyword();
        CMURI keywordURI = new CMURI(null, -1, -1, -1, -1);
        try {
            keywordURI = new CMURI(structureGroup);
        }
        catch (ParseException e) {
            LOG.warn("Unable to parse the URI's for related keyword, assuming legacy keyword relations");
        }
        relatedKeywordEntity.setKeywordId(keywordURI.getItemId());
        relatedKeywordEntity.setTaxonomyId(keywordURI.getItemId());
        relatedKeywordEntity.setCategoryName(structureGroup);
        relatedKeywordEntity.setKeywordName(structureGroup);
        relatedKeywordEntity.setNamespaceId(this.getNamespaceId());
        relatedKeywordEntity.setPublicationId(this.getPublicationId());
        relatedKeywordEntity.setItemId(this.getItemId());
        relatedKeywordEntity.setTaxFacetType(keywordURI.getItemType());
        return relatedKeywordEntity;
    }

    @Override
    public String toString() {
        return "PageMeta{entityId=" + this.getEntityId() + ", fileName='" + this.fileName + "', url='" + this.url + "', templateId=" + this.templateId + ", contentId=" + this.contentId + ", entityNamespaceId=" + this.entityNamespaceId + ", entityPublicationId=" + this.entityPublicationId + ", entityItemId=" + this.entityItemId + ", schemaId=" + this.schemaId + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PageMeta)) {
            return false;
        }
        PageMeta pageMeta = (PageMeta)o;
        return super.equals(o) && this.templateId == pageMeta.templateId && Objects.equals(this.fileName, pageMeta.fileName) && Objects.equals(this.url, pageMeta.url) && Objects.equals(this.contentId, pageMeta.contentId) && Objects.equals(this.schemaId, pageMeta.schemaId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fileName, this.url, this.templateId, this.contentId, this.schemaId, super.hashCode());
    }
}

