/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.storage.ItemMeta;
import com.tridion.storage.entities.PublicationEntity;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="PUBLICATIONS")
public class Publication
extends ItemMeta
implements PublicationEntity {
    private static final int FOUR = 4;
    private int id;
    private int entityNamespaceId;
    private int entityPublicationId;
    private int entityItemId;
    private String key;
    private String publicationPath;
    private String publicationUrl;
    private String multimediaPath;
    private String multimediaUrl;
    private String publicationTitle;

    public Publication() {
        this.setItemSelector("publication");
        this.setItemType(1);
        this.setTrustee("unknown");
    }

    public Publication(int namespaceId, int publicationId) {
        this();
        this.setNamespaceId(namespaceId);
        this.setPublicationId(publicationId);
        this.setItemId(publicationId);
    }

    public Publication(int namespaceId, int publicationId, String title, String key, String publicationPath, String publicationUrl, String multimediaPath, String multimediaUrl) {
        this();
        this.setNamespaceId(namespaceId);
        this.setPublicationId(publicationId);
        this.setItemId(publicationId);
        this.setTitle(title);
        this.key = key;
        this.publicationPath = publicationPath;
        this.publicationUrl = publicationUrl;
        this.multimediaPath = multimediaPath;
        this.multimediaUrl = multimediaUrl;
    }

    @Column(name="NAMESPACE_ID")
    public int getEntityNamespaceId() {
        return this.entityNamespaceId;
    }

    @Column(name="ITEM_REFERENCE_ID")
    public int getEntityItemId() {
        return this.entityItemId;
    }

    @Column(name="PUBLICATION_ID")
    public int getEntityPublicationId() {
        return this.entityPublicationId;
    }

    public void setEntityNamespaceId(int componentNamespaceId) {
        this.entityNamespaceId = componentNamespaceId;
    }

    public void setEntityPublicationId(int componentPublicationId) {
        this.entityPublicationId = componentPublicationId;
    }

    public void setEntityItemId(int componentItemId) {
        this.entityItemId = componentItemId;
    }

    @Override
    public void setNamespaceId(int namespaceId) {
        super.setNamespaceId(namespaceId);
        this.setEntityNamespaceId(namespaceId);
    }

    @Override
    @Column(name="PUBLICATION_ID", insertable=false, updatable=false)
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public void setPublicationId(int publicationId) {
        super.setPublicationId(publicationId);
        this.setEntityPublicationId(publicationId);
    }

    @Override
    public void setItemId(int itemId) {
        super.setItemId(itemId);
        this.setEntityItemId(itemId);
    }

    @Column(name="PUBLICATION_TITLE")
    public String getPublicationTitle() {
        return this.publicationTitle;
    }

    public void setPublicationTitle(String publicationTitle) {
        this.publicationTitle = publicationTitle;
    }

    @Override
    @Column(name="PUBLICATION_KEY")
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    @Column(name="PUBLICATION_PATH")
    public String getPublicationPath() {
        return this.publicationPath;
    }

    @Override
    public void setPublicationPath(String publicationPath) {
        this.publicationPath = publicationPath;
    }

    @Override
    @Column(name="PUBLICATION_URL")
    public String getPublicationUrl() {
        return this.publicationUrl;
    }

    @Override
    public void setPublicationUrl(String publicationUrl) {
        this.publicationUrl = publicationUrl;
    }

    @Override
    @Column(name="MULTIMEDIA_PATH")
    public String getMultimediaPath() {
        return this.multimediaPath;
    }

    @Override
    public void setMultimediaPath(String multimediaPath) {
        this.multimediaPath = multimediaPath;
    }

    @Override
    @Column(name="MULTIMEDIA_URL")
    public String getMultimediaUrl() {
        return this.multimediaUrl;
    }

    @Override
    public void setMultimediaUrl(String multimediaUrl) {
        this.multimediaUrl = multimediaUrl;
    }

    @Override
    public String toString() {
        return "Publication{entityId=" + this.getEntityId() + ", key='" + this.key + "', publicationPath='" + this.publicationPath + "', publicationUrl='" + this.publicationUrl + "', multimediaPath='" + this.multimediaPath + "', multimediaUrl='" + this.multimediaUrl + "', publicationTitle='" + this.publicationTitle + "', entityNamespaceId=" + this.entityNamespaceId + ", entityPublicationId=" + this.entityPublicationId + ", entityItemId=" + this.entityItemId + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Publication)) {
            return false;
        }
        Publication that = (Publication)o;
        return super.equals(o) && Objects.equals(this.key, that.key) && Objects.equals(this.publicationPath, that.publicationPath) && Objects.equals(this.publicationUrl, that.publicationUrl) && Objects.equals(this.multimediaPath, that.multimediaPath) && Objects.equals(this.multimediaUrl, that.multimediaUrl) && Objects.equals(this.publicationTitle, that.publicationTitle);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.publicationPath, this.publicationUrl, this.multimediaPath, this.multimediaUrl, this.publicationTitle, super.hashCode());
    }
}

