/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.storage.BaseEntityImpl;
import com.tridion.storage.SourceSystem;
import com.tridion.storage.entities.ReferenceEntryEntity;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="REFERENCE_ENTRIES")
public class ReferenceEntry
extends BaseEntityImpl
implements ReferenceEntryEntity {
    private Long entityId;
    private int namespaceId;
    private int publicationId;
    private String referencedURI;
    private String referencingURI;
    private SourceSystem sourceSystem;
    private Long itemType;

    @Id
    @Column(name="REFERENCE_ENTRIES_KEY", updatable=false)
    @SequenceGenerator(name="SEQ_REFERENCE_ENTRIES_KEY", sequenceName="SEQ_REFERENCE_ENTRIES_KEY")
    @GeneratedValue(generator="SEQ_REFERENCE_ENTRIES_KEY")
    public Long getEntityId() {
        return this.entityId;
    }

    @Override
    @Transient
    public Object getPK() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    @Override
    @Column(name="NAMESPACE_ID")
    public int getNamespaceId() {
        return this.namespaceId;
    }

    @Override
    public void setNamespaceId(int namespaceId) {
        this.namespaceId = namespaceId;
    }

    @Override
    @Column(name="PUBLICATION_ID")
    public int getPublicationId() {
        return this.publicationId;
    }

    @Override
    public void setPublicationId(int publicationId) {
        this.publicationId = publicationId;
    }

    @Override
    @Column(name="REFERENCED_URI")
    public String getReferencedURI() {
        return this.referencedURI;
    }

    @Override
    public void setReferencedURI(String referencedURI) {
        this.referencedURI = referencedURI;
    }

    @Override
    @Column(name="REFERENCING_URI")
    public String getReferencingURI() {
        return this.referencingURI;
    }

    @Override
    public void setReferencingURI(String referencingURI) {
        this.referencingURI = referencingURI;
    }

    @Column(name="SOURCE_SYSTEM")
    @Enumerated(value=EnumType.STRING)
    public SourceSystem getSourceSystem() {
        return this.sourceSystem;
    }

    public void setSourceSystem(SourceSystem sourceSystem) {
        this.sourceSystem = sourceSystem;
    }

    @Column(name="ITEM_TYPE")
    public Long getItemType() {
        return this.itemType;
    }

    public void setItemType(Long itemType) {
        this.itemType = itemType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReferenceEntry)) {
            return false;
        }
        ReferenceEntry that = (ReferenceEntry)o;
        return this.namespaceId == that.namespaceId && this.publicationId == that.publicationId && Objects.equals(this.referencedURI, that.referencedURI) && Objects.equals(this.referencingURI, that.referencingURI);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceId, this.publicationId, this.referencedURI, this.referencingURI);
    }
}

