/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.storage.BaseEntityImpl;
import com.tridion.storage.ItemMeta;
import com.tridion.storage.entities.RelatedKeywordEntity;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ITEM_CATEGORIES_AND_KEYWORDS")
public class RelatedKeyword
extends BaseEntityImpl
implements RelatedKeywordEntity {
    private static final int SEVEN = 7;
    private int relationId;
    private int namespaceId;
    private int keywordId;
    private int taxonomyId;
    private String categoryName;
    private String keywordName;
    private int publicationId;
    private int itemId;
    private int taxFacetType;
    private ItemMeta relatedItem;
    private Long relatedItemId;

    @Override
    @Transient
    public Object getPK() {
        return this.relationId;
    }

    @Override
    @Id
    @Column(name="RELATION_ID")
    @SequenceGenerator(name="SEQ_ITC_KEY", sequenceName="SEQ_ITC_KEY")
    @GeneratedValue(generator="SEQ_ITC_KEY")
    public int getRelationId() {
        return this.relationId;
    }

    @Override
    public void setRelationId(int relationId) {
        this.relationId = relationId;
    }

    @Override
    @Column(name="NAMESPACE_ID")
    public int getNamespaceId() {
        return this.namespaceId;
    }

    @Override
    public void setNamespaceId(int namespaceId) {
        this.namespaceId = namespaceId;
    }

    @Override
    @Column(name="KEYWORD_ID")
    public int getKeywordId() {
        return this.keywordId;
    }

    @Override
    public void setKeywordId(int keywordId) {
        this.keywordId = keywordId;
    }

    @Override
    @Column(name="TAXONOMY_ID")
    public int getTaxonomyId() {
        return this.taxonomyId;
    }

    @Override
    public void setTaxonomyId(int taxonomyId) {
        this.taxonomyId = taxonomyId;
    }

    @Override
    @Column(name="CATEGORY")
    public String getCategoryName() {
        return this.categoryName;
    }

    @Override
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    @Override
    @Column(name="KEYWORD")
    public String getKeywordName() {
        return this.keywordName;
    }

    @Override
    public void setKeywordName(String keywordName) {
        this.keywordName = keywordName;
    }

    @Override
    @Column(name="PUBLICATION_ID")
    public int getPublicationId() {
        return this.publicationId;
    }

    @Override
    public void setPublicationId(int publicationId) {
        this.publicationId = publicationId;
    }

    @Override
    @Column(name="ITEM_REFERENCE_ID")
    public int getItemId() {
        return this.itemId;
    }

    @Override
    public void setItemId(int itemId) {
        this.itemId = itemId;
    }

    @Override
    @Column(name="TAXFACET_TYPE")
    public int getTaxFacetType() {
        return this.taxFacetType;
    }

    @Override
    public void setTaxFacetType(int taxFacetType) {
        this.taxFacetType = taxFacetType;
    }

    @Override
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ITEMS_KEY", referencedColumnName="ITEMS_KEY", insertable=false, updatable=false)
    public ItemMeta getRelatedItem() {
        return this.relatedItem;
    }

    @Column(name="ITEMS_KEY")
    public Long getRelatedItemId() {
        return this.relatedItemId;
    }

    public void setRelatedItemId(Long relatedItemId) {
        this.relatedItemId = relatedItemId;
    }

    @Override
    public void setRelatedItem(ItemMeta relatedItem) {
        this.relatedItem = relatedItem;
    }

    public String toString() {
        return "RelatedKeyword{namespaceId=" + this.namespaceId + ", keywordId=" + this.keywordId + ", taxonomyId=" + this.taxonomyId + ", categoryName='" + this.categoryName + "', keywordName='" + this.keywordName + "', publicationId=" + this.publicationId + ", itemId=" + this.itemId + ", taxFacetType=" + this.taxFacetType + ", relatedItemId=" + this.relatedItemId + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelatedKeyword)) {
            return false;
        }
        RelatedKeyword that = (RelatedKeyword)o;
        return Objects.equals(this.namespaceId, that.namespaceId) && Objects.equals(this.keywordId, that.keywordId) && Objects.equals(this.taxonomyId, that.taxonomyId) && Objects.equals(this.publicationId, that.publicationId) && Objects.equals(this.itemId, that.itemId) && Objects.equals(this.taxFacetType, that.taxFacetType) && Objects.equals(this.categoryName, that.categoryName) && Objects.equals(this.keywordName, that.keywordName) && Objects.equals(this.relatedItemId, that.relatedItemId);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceId, this.keywordId, this.taxonomyId, this.categoryName, this.keywordName, this.publicationId, this.itemId, this.taxFacetType, this.relatedItemId);
    }
}

