/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.storage.BaseEntityImpl;
import com.tridion.storage.entities.SchemaEntity;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="`SCHEMAS`")
public class Schema
extends BaseEntityImpl
implements SchemaEntity {
    private static final int LENGTH = 10000000;
    private static final int FOUR = 4;
    private int namespaceId;
    private int publicationId;
    private int schemaId;
    private String schemaContent;
    private String title = "Schema-Title";
    private Integer contentId;
    private Long entityId;

    @Id
    @Column(name="SCHEMAS_KEY", updatable=false)
    @SequenceGenerator(name="SEQ_SCHEMAS_KEY", sequenceName="SEQ_SCHEMAS_KEY")
    @GeneratedValue(generator="SEQ_SCHEMAS_KEY")
    public Long getEntityId() {
        return this.entityId;
    }

    @Override
    @Transient
    public Object getPK() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    @Override
    @Column(name="NAMESPACE_ID")
    public int getNamespaceId() {
        return this.namespaceId;
    }

    @Override
    public void setNamespaceId(int namespaceId) {
        this.namespaceId = namespaceId;
    }

    @Override
    @Column(name="PUBLICATION_ID")
    public int getPublicationId() {
        return this.publicationId;
    }

    @Override
    public void setPublicationId(int publicationId) {
        this.publicationId = publicationId;
    }

    @Override
    @Column(name="SCHEMA_ID")
    public int getSchemaId() {
        return this.schemaId;
    }

    @Override
    public void setSchemaId(int schemaId) {
        this.schemaId = schemaId;
    }

    @Override
    @Column(name="CONTENT", length=10000000)
    public String getSchemaContent() {
        return this.schemaContent;
    }

    @Override
    public void setSchemaContent(String schemaContent) {
        this.schemaContent = schemaContent;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @Column(name="TITLE")
    public String getTitle() {
        return this.title;
    }

    @Column(name="CONTENT_ID")
    public Integer getContentId() {
        return this.contentId;
    }

    public void setContentId(Integer contentId) {
        this.contentId = contentId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Schema{");
        sb.append("namespaceId=").append(this.namespaceId);
        sb.append(", publicationId=").append(this.publicationId);
        sb.append(", schemaId=").append(this.schemaId);
        sb.append(", schemaContent='").append(this.schemaContent).append('\'');
        sb.append(", title='").append(this.title).append('\'');
        sb.append(", contentId='").append(this.contentId).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema schema = (Schema)o;
        return this.namespaceId == schema.namespaceId && this.publicationId == schema.publicationId && this.schemaId == schema.schemaId && Objects.equals(this.schemaContent, schema.schemaContent) && Objects.equals(this.title, schema.title) && Objects.equals(this.contentId, schema.contentId);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceId, this.publicationId, this.schemaId, this.schemaContent, this.title, this.contentId);
    }
}

