/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.storage.TaxonomyItem;
import com.tridion.storage.entities.StructureGroupEntity;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

@Entity
@DiscriminatorValue(value="StructureGroup")
public class StructureGroup
extends TaxonomyItem
implements StructureGroupEntity {
    private String title;
    private String directory;

    public StructureGroup() {
    }

    public StructureGroup(int namespaceId, int publicationId, int taxonomyId) {
        super.setNamespaceId(namespaceId);
        super.setPublicationId(publicationId);
        super.setTaxonomyId(taxonomyId);
    }

    @Override
    @Column(name="FACET_DESCRIPTION")
    public String getDirectory() {
        return this.directory;
    }

    @Override
    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Override
    @Column(name="FACET_NAME")
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String toString() {
        return String.format("StructureGroup [depth=%s, id=%s, internalId=%s, itemSelector=%s, itemType=%s, left=%s, parent=%s, namespaceId=%s, publicationId=%s, relatedItems=%s, right=%s, taxonomyId=%s, hasChildren=%s, title=%s, directory=%s]", this.getDepth(), this.getId(), this.getInternalId(), "StructureGroup", this.getItemType(), this.getLeft(), this.getParent(), this.getNamespaceId(), this.getPublicationId(), this.getRelatedItems(), this.getRight(), this.getTaxonomyId(), this.isHasChildren(), this.getTitle(), this.getDirectory());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StructureGroup that = (StructureGroup)o;
        return Objects.equals(this.title, that.title) && Objects.equals(this.directory, that.directory);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.title, this.directory);
    }
}

