/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.api.TaxonomyItemBase;
import com.tridion.storage.BaseEntityImpl;
import com.tridion.storage.KeywordRelation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="TAXFACETS")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="ITEM_SELECTOR", discriminatorType=DiscriminatorType.STRING)
public class TaxonomyItem
extends BaseEntityImpl
implements TaxonomyItemBase {
    private int internalId;
    private int id;
    private int namespaceId;
    private int publicationId;
    private int taxonomyId;
    private String parent;
    private boolean hasChildren;
    private boolean isAbstract;
    private boolean isNavigable;
    private String key;
    private int depth;
    private int left;
    private int right;
    private int itemType;
    private int relatedItems = -1;
    private int totalRelatedItems;
    private static final int THREE = 3;
    private static final int ELEVEN = 11;
    private List<KeywordRelation> keywordRelations = new ArrayList<KeywordRelation>();

    public TaxonomyItem() {
    }

    public TaxonomyItem(int namespaceId, int publicationId, int taxonomyId) {
        this.namespaceId = namespaceId;
        this.publicationId = publicationId;
        this.taxonomyId = taxonomyId;
    }

    @Override
    @Id
    @Column(name="NODE_ID")
    @SequenceGenerator(name="SEQ_TAXFACETS", sequenceName="SEQ_TAXFACETS")
    @GeneratedValue(generator="SEQ_TAXFACETS")
    public int getInternalId() {
        return this.internalId;
    }

    public void setInternalId(int internalId) {
        this.internalId = internalId;
    }

    @Override
    @Column(name="FACET_ID")
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Column(name="NAMESPACE_ID")
    public int getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(int namespaceId) {
        this.namespaceId = namespaceId;
    }

    @Override
    @Column(name="PUBLICATION_ID")
    public int getPublicationId() {
        return this.publicationId;
    }

    public void setPublicationId(int publicationId) {
        this.publicationId = publicationId;
    }

    @Column(name="TAXONOMY_ID")
    public int getTaxonomyId() {
        return this.taxonomyId;
    }

    public void setTaxonomyId(int taxonomyId) {
        this.taxonomyId = taxonomyId;
    }

    @Column(name="FACET_PARENT")
    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    @Column(name="FACET_HASCHILDREN")
    public boolean isHasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    @Column(name="FACET_ISABSTRACT")
    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean abstractValue) {
        this.isAbstract = abstractValue;
    }

    @Column(name="FACET_ISNAVIGABLE")
    public boolean isNavigable() {
        return this.isNavigable;
    }

    public void setNavigable(boolean navigable) {
        this.isNavigable = navigable;
    }

    @Column(name="FACET_KEY")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Column(name="FACET_DEPTH")
    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    @Override
    @Column(name="FACET_LEFT")
    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    @Override
    @Column(name="FACET_RIGHT")
    public int getRight() {
        return this.right;
    }

    public void setRight(int right) {
        this.right = right;
    }

    @Override
    @Column(name="FACET_ITEMTYPE")
    public int getItemType() {
        return this.itemType;
    }

    public void setItemType(int itemType) {
        this.itemType = itemType;
    }

    @Transient
    public int getRelatedItems() {
        if (this.relatedItems == -1) {
            return this.totalRelatedItems;
        }
        return this.relatedItems;
    }

    public void setRelatedItems(int relatedItems) {
        this.relatedItems = relatedItems;
    }

    @Column(name="TOTAL_RELATEDITEMS")
    public int getTotalRelatedItems() {
        return this.totalRelatedItems;
    }

    public void setTotalRelatedItems(int totalRelatedItems) {
        this.totalRelatedItems = totalRelatedItems;
    }

    @OneToMany(mappedBy="taxonomyItem", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SUBSELECT)
    public List<KeywordRelation> getKeywordRelations() {
        return this.keywordRelations;
    }

    public void setKeywordRelations(List<KeywordRelation> keywordRelationEntities) {
        this.keywordRelations = keywordRelationEntities;
    }

    @Transient
    public void addKeywordRelation(KeywordRelation keywordRelation) {
        this.keywordRelations.add(keywordRelation);
    }

    @Override
    @Transient
    public Object getPK() {
        return this.internalId;
    }

    @Override
    @Transient
    public void setPK(Object objectInternalId) {
        this.internalId = (Integer)objectInternalId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TaxonomyItem{");
        sb.append("internalId=").append(this.internalId);
        sb.append(", id=").append(this.id);
        sb.append(", namespaceId=").append(this.namespaceId);
        sb.append(", publicationId=").append(this.publicationId);
        sb.append(", taxonomyId=").append(this.taxonomyId);
        sb.append(", parent='").append(this.parent).append('\'');
        sb.append(", hasChildren=").append(this.hasChildren);
        sb.append(", isAbstract=").append(this.isAbstract);
        sb.append(", isNavigable=").append(this.isNavigable);
        sb.append(", key='").append(this.key).append('\'');
        sb.append(", depth=").append(this.depth);
        sb.append(", left=").append(this.left);
        sb.append(", right=").append(this.right);
        sb.append(", itemType=").append(this.itemType);
        sb.append(", relatedItems=").append(this.relatedItems);
        sb.append(", totalRelatedItems=").append(this.totalRelatedItems);
        sb.append(", keywordRelations=").append(this.keywordRelations);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxonomyItem that = (TaxonomyItem)o;
        return this.id == that.id && this.namespaceId == that.namespaceId && this.publicationId == that.publicationId && this.taxonomyId == that.taxonomyId && this.hasChildren == that.hasChildren && this.isAbstract == that.isAbstract && this.isNavigable == that.isNavigable && this.depth == that.depth && this.left == that.left && this.right == that.right && this.itemType == that.itemType && this.totalRelatedItems == that.totalRelatedItems && Objects.equals(this.parent, that.parent) && Objects.equals(this.key, that.key) && Objects.equals(new ArrayList<KeywordRelation>(this.keywordRelations), new ArrayList<KeywordRelation>(that.keywordRelations));
    }

    public int hashCode() {
        return Objects.hash(this.id, this.namespaceId, this.publicationId, this.taxonomyId, this.parent, this.hasChildren, this.isAbstract, this.isNavigable, this.key, this.depth, this.left, this.right, this.itemType, this.totalRelatedItems, new ArrayList<KeywordRelation>(this.keywordRelations));
    }
}

