/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.storage.ComponentPresentationMeta;
import com.tridion.storage.ItemMeta;
import com.tridion.storage.entities.TemplateMetaEntity;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="TEMPLATE")
public class TemplateMeta
extends ItemMeta
implements TemplateMetaEntity {
    private static final int FOUR = 4;
    private Integer priority;
    private String outputFormat;
    private int entityNamespaceId;
    private int entityItemId;
    private int entityPublicationId;
    private List<ComponentPresentationMeta> componentPresentationMetaList;

    public TemplateMeta() {
        this.setItemSelector("template");
        this.setItemType(32);
        this.setTitle("template");
        this.setTrustee("unknown");
        this.componentPresentationMetaList = new ArrayList<ComponentPresentationMeta>();
    }

    @Override
    public void setNamespaceId(int namespaceId) {
        super.setNamespaceId(namespaceId);
        this.setEntityNamespaceId(namespaceId);
    }

    @Override
    public void setPublicationId(int publicationId) {
        super.setPublicationId(publicationId);
        this.setEntityPublicationId(publicationId);
    }

    @Override
    public void setItemId(int itemId) {
        super.setItemId(itemId);
        this.setEntityItemId(itemId);
    }

    @Override
    @Column(name="TEMPLATE_PRIORITY")
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @Override
    @Column(name="TEMPLATE_OUTPUT_FORMAT", nullable=false)
    public String getOutputFormat() {
        return this.outputFormat;
    }

    @Override
    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    @Override
    @OneToMany(mappedBy="templateMeta")
    public List<ComponentPresentationMeta> getComponentPresentationMetas() {
        return this.componentPresentationMetaList;
    }

    @Override
    public void setComponentPresentationMetas(List<ComponentPresentationMeta> componentPresentationMetas) {
        this.componentPresentationMetaList = componentPresentationMetas;
    }

    @Override
    public void addComponentPresentationMeta(ComponentPresentationMeta componentPresentationMeta) {
        this.componentPresentationMetaList.add(componentPresentationMeta);
    }

    @Column(name="NAMESPACE_ID")
    public int getEntityNamespaceId() {
        return this.entityNamespaceId;
    }

    @Column(name="ITEM_REFERENCE_ID")
    public int getEntityItemId() {
        return this.entityItemId;
    }

    @Column(name="PUBLICATION_ID")
    public int getEntityPublicationId() {
        return this.entityPublicationId;
    }

    public void setEntityNamespaceId(int entityNamespaceId) {
        this.entityNamespaceId = entityNamespaceId;
    }

    public void setEntityItemId(int entityItemId) {
        this.entityItemId = entityItemId;
    }

    public void setEntityPublicationId(int entityPublicationId) {
        this.entityPublicationId = entityPublicationId;
    }

    @Override
    public String toString() {
        return "TemplateMeta{entityId=" + this.getEntityId() + ", priority=" + this.priority + ", outputFormat='" + this.outputFormat + "', entityNamespaceId=" + this.entityNamespaceId + ", entityItemId=" + this.entityItemId + ", entityPublicationId=" + this.entityPublicationId + "}";
    }
}

