/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage;

import com.tridion.storage.BaseEntityImpl;
import com.tridion.storage.entities.XSLTContentEntity;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@Table(name="XSLT_CONTENT")
public class XSLTContent
extends BaseEntityImpl
implements XSLTContentEntity {
    private static final int THREE = 3;
    private Long entityId;
    private int namespaceId;
    private int publicationId;
    private int xsltId;
    private Date lastModified;
    private String content;

    public XSLTContent() {
    }

    public XSLTContent(int namespaceId, int publicationId, int xsltId, long lastModified, String content) {
        this.namespaceId = namespaceId;
        this.publicationId = publicationId;
        this.xsltId = xsltId;
        this.lastModified = new Date(lastModified);
        this.content = content;
    }

    @Id
    @Column(name="XSLT_CONTENT_KEY", updatable=false)
    @SequenceGenerator(name="SEQ_XSLT_CONTENT_KEY", sequenceName="SEQ_XSLT_CONTENT_KEY")
    @GeneratedValue(generator="SEQ_XSLT_CONTENT_KEY")
    public Long getEntityId() {
        return this.entityId;
    }

    @Override
    @Transient
    public Object getPK() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    @Override
    @Column(name="NAMESPACE_ID")
    public int getNamespaceId() {
        return this.namespaceId;
    }

    @Override
    public void setNamespaceId(int namespaceId) {
        this.namespaceId = namespaceId;
    }

    @Override
    @Column(name="PUBLICATION_ID")
    public int getPublicationId() {
        return this.publicationId;
    }

    @Override
    public void setPublicationId(int publicationId) {
        this.publicationId = publicationId;
    }

    @Override
    @Column(name="XSLT_ID")
    public int getXsltId() {
        return this.xsltId;
    }

    @Override
    public void setXsltId(int xsltId) {
        this.xsltId = xsltId;
    }

    @Override
    @Column(name="LAST_MODIFIED")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    @Column(name="CONTENT")
    public String getContent() {
        return this.content;
    }

    @Override
    public void setContent(String content) {
        this.content = content;
    }

    public String toString() {
        return "XSLTContent{entityId=" + this.entityId + ", namespaceId=" + this.namespaceId + ", publicationId=" + this.publicationId + ", xsltId=" + this.xsltId + ", lastModified=" + this.lastModified + ", content='" + this.content + "'}";
    }
}

