/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.storage.dao;

import java.util.Arrays;
import java.util.Optional;

public enum ItemTypeSelector {
    COMPONENT("component", "ComponentMeta", "componentmeta"),
    TEMPLATE("template", "TemplateMeta", "componentpresentationmeta"),
    KEYWORD("keyword", "KeywordMeta", "keywordmeta"),
    PAGE("page", "PageMeta", "pagemeta"),
    PUBLICATION("publication", "Publication", "publication");

    private final String itemSelector;
    private final String entityName;
    private final String itemLocation;
    public static final String BINARY_ENTITY_NAME = "BinaryMeta";
    public static final String BINARY_ITEM_LOCATION = "binarymeta";

    private ItemTypeSelector(String itemSelector, String entityName, String itemLocation) {
        this.itemSelector = itemSelector;
        this.entityName = entityName;
        this.itemLocation = itemLocation;
    }

    public String getItemSelector() {
        return this.itemSelector;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getItemLocation() {
        return this.itemLocation;
    }

    public int getItemTypeId() {
        return switch (this) {
            case COMPONENT -> 16;
            case TEMPLATE -> 32;
            case PAGE -> 64;
            case KEYWORD -> 1024;
            default -> -1;
        };
    }

    public String toString() {
        return this.getItemSelector();
    }

    public static ItemTypeSelector of(String itemSelector) {
        if (itemSelector == null) {
            throw new IllegalArgumentException("ItemSelector parameter should not be null.");
        }
        Optional<ItemTypeSelector> itemTypeSelector = Arrays.stream(ItemTypeSelector.values()).filter(value -> itemSelector.equals(value.getItemSelector())).findFirst();
        return itemTypeSelector.orElseThrow();
    }
}

