/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.taxonomies;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.tridion.meta.CustomMeta;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Keyword
implements Serializable,
Comparable {
    @JsonBackReference
    private List<Keyword> keywordChildren;
    private List<Keyword> parentKeywords;
    private Keyword primaryParentKeyword;
    private CustomMeta keywordMeta;
    private boolean hasKeywordChildren;
    private boolean keywordAbstract;
    private boolean keywordNavigable;
    private boolean usedForIdentification;
    private String keywordName;
    private String keywordDescription;
    private String keywordURI;
    private String taxonomyURI;
    private int referencedContentCount;
    private List<String> relatedKeywordURIS;
    private int keywordLeft;
    private int keywordRight;
    private int keywordDepth;
    private String keywordKey;
    private String keywordTitle;

    public Keyword(String taxonomyURI, String keywordURI, String keywordName, Keyword parentKeyword) {
        this.keywordName = keywordName;
        this.keywordURI = keywordURI;
        this.taxonomyURI = taxonomyURI;
        this.hasKeywordChildren = false;
        this.keywordAbstract = false;
        this.keywordNavigable = true;
        this.usedForIdentification = false;
        this.referencedContentCount = 0;
        this.keywordLeft = 0;
        this.keywordRight = 0;
        this.relatedKeywordURIS = new ArrayList<String>();
        this.keywordKey = "";
        this.keywordTitle = "";
        this.keywordDescription = "";
        this.keywordMeta = new CustomMeta("custom-meta", Collections.EMPTY_MAP, null);
        this.keywordChildren = new ArrayList<Keyword>();
        this.parentKeywords = new ArrayList<Keyword>();
        this.setParentKeyword(parentKeyword, true);
    }

    public Keyword(String taxonomyURI, String keywordURI, String keywordName) {
        this(taxonomyURI, keywordURI, keywordName, null);
    }

    public Keyword(String taxonomyURI, String keywordURI) {
        this(taxonomyURI, keywordURI, "", null);
    }

    public String getKeywordURI() {
        return this.keywordURI;
    }

    public List<Keyword> getParentKeywords() {
        return this.parentKeywords;
    }

    public Keyword getParentKeyword() {
        return this.primaryParentKeyword;
    }

    public void setParentKeyword(Keyword parentKeyword, boolean thePrimaryParentKeyword) {
        if (parentKeyword != null) {
            boolean addParent = true;
            for (Keyword existingParentKeyword : this.parentKeywords) {
                if (!existingParentKeyword.getKeywordURI().equals(parentKeyword.getKeywordURI())) continue;
                addParent = false;
            }
            if (addParent) {
                this.parentKeywords.add(parentKeyword);
            }
            if (thePrimaryParentKeyword) {
                this.setPrimaryParentKeyword(parentKeyword);
            }
        }
    }

    public void setParentKeyword(Keyword parentKeyword) {
        this.setParentKeyword(parentKeyword, true);
    }

    private void setPrimaryParentKeyword(Keyword parentKeyword) {
        if (parentKeyword != null) {
            this.primaryParentKeyword = parentKeyword;
            parentKeyword.keywordChildren.add(this);
        }
    }

    public List<Keyword> getKeywordChildren() {
        ArrayList<Keyword> keywords = new ArrayList<Keyword>(this.keywordChildren);
        Collections.sort(keywords);
        return keywords;
    }

    public String getKeywordName() {
        return this.keywordName;
    }

    public String getTaxonomyURI() {
        return this.taxonomyURI;
    }

    public boolean hasKeywordChildren() {
        return this.hasKeywordChildren;
    }

    public void setHasKeywordChildren(boolean hasKeywordChildren) {
        this.hasKeywordChildren = hasKeywordChildren;
    }

    public boolean isKeywordAbstract() {
        return this.keywordAbstract;
    }

    public void setKeywordAbstract(boolean keywordAbstract) {
        this.keywordAbstract = keywordAbstract;
    }

    public boolean isUsedForIdentification() {
        return this.usedForIdentification;
    }

    public void setUsedForIdentification(boolean usedForIdentification) {
        this.usedForIdentification = usedForIdentification;
    }

    public boolean isKeywordNavigable() {
        return this.keywordNavigable;
    }

    public void setKeywordNavigable(boolean keywordNavigable) {
        this.keywordNavigable = keywordNavigable;
    }

    public int getReferencedContentCount() {
        return this.referencedContentCount;
    }

    public void setReferencedContentCount(int referencedContentCount) {
        this.referencedContentCount = referencedContentCount;
    }

    public String getKeywordKey() {
        return this.keywordKey;
    }

    public void setKeywordKey(String keywordKey) {
        this.keywordKey = keywordKey;
    }

    public String getKeywordTitle() {
        return this.keywordTitle;
    }

    public void setKeywordTitle(String keywordTitle) {
        this.keywordTitle = keywordTitle;
    }

    public CustomMeta getKeywordMeta() {
        return this.keywordMeta;
    }

    public void setKeywordMeta(CustomMeta keywordMeta) {
        this.keywordMeta = keywordMeta;
    }

    public void addRelatedKeywordURI(String relatedKeywordURI) {
        this.relatedKeywordURIS.add(relatedKeywordURI);
    }

    public String[] getRelatedKeywordURIS() {
        return this.relatedKeywordURIS.toArray(new String[this.relatedKeywordURIS.size()]);
    }

    public String toString() {
        return "TaxonomyKeyword: " + this.keywordName + ", URI: " + this.keywordURI + " Taxonomy: " + this.taxonomyURI;
    }

    public int getKeywordLeft() {
        return this.keywordLeft;
    }

    public void setKeywordLeft(int keywordLeft) {
        this.keywordLeft = keywordLeft;
    }

    public int getKeywordRight() {
        return this.keywordRight;
    }

    public void setKeywordRight(int keywordRight) {
        this.keywordRight = keywordRight;
    }

    public int getKeywordDepth() {
        return this.keywordDepth;
    }

    public void setKeywordDepth(int keywordDepth) {
        this.keywordDepth = keywordDepth;
    }

    public String getKeywordDescription() {
        return this.keywordDescription;
    }

    public void setKeywordDescription(String keywordDescription) {
        this.keywordDescription = keywordDescription;
    }

    protected void setKeywordName(String keywordName) {
        this.keywordName = keywordName;
    }

    public int compareTo(Object o) {
        if (o instanceof Keyword) {
            Keyword compareKeyword = (Keyword)o;
            return compareKeyword.keywordLeft > this.keywordLeft ? 0 : 1;
        }
        return 0;
    }

    public List<Keyword> clone(int left, Keyword parentKeyword) {
        ArrayList<Keyword> clones = new ArrayList<Keyword>();
        int currentLeft = left;
        Keyword clonedKeyword = new Keyword(this.taxonomyURI, this.keywordURI, this.keywordName, parentKeyword);
        clonedKeyword.hasKeywordChildren = this.hasKeywordChildren;
        clonedKeyword.keywordAbstract = this.keywordAbstract;
        clonedKeyword.keywordDescription = this.keywordDescription;
        clonedKeyword.keywordKey = this.keywordKey;
        clonedKeyword.keywordTitle = this.keywordTitle;
        clonedKeyword.keywordMeta = this.keywordMeta;
        clonedKeyword.keywordNavigable = this.keywordNavigable;
        clonedKeyword.relatedKeywordURIS = new ArrayList<String>(this.relatedKeywordURIS);
        clonedKeyword.usedForIdentification = this.usedForIdentification;
        clonedKeyword.keywordLeft = currentLeft;
        clones.add(clonedKeyword);
        for (Keyword child : this.keywordChildren) {
            List<Keyword> childClones = child.clone(++currentLeft, clonedKeyword);
            clones.addAll(childClones);
            currentLeft = childClones.get(0).getKeywordRight();
        }
        clonedKeyword.keywordRight = ++currentLeft;
        return clones;
    }
}

