/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.api.parser.util;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.ODataNotImplementedException;
import com.sdl.odata.api.edm.ODataEdmException;
import com.sdl.odata.api.edm.model.EnumMember;
import com.sdl.odata.api.edm.model.EnumType;
import com.sdl.odata.api.edm.model.PrimitiveType;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.api.unmarshaller.ODataUnmarshallingException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.UUID;

public final class ParserUtil {
    private static final int PARSE_INDEX = 255;

    private ParserUtil() {
    }

    public static Object parsePrimitiveValue(String value, PrimitiveType primitiveType) throws ODataException {
        switch (primitiveType) {
            case BOOLEAN: {
                return Boolean.valueOf(value);
            }
            case BYTE: {
                try {
                    Integer v = Integer.valueOf(value);
                    if (v < 0 || v > 255) {
                        ParserUtil.throwParseException(value, primitiveType, null);
                    }
                    return v.byteValue();
                }
                catch (NumberFormatException e) {
                    ParserUtil.throwParseException(value, primitiveType, e);
                    break;
                }
            }
            case DATE: {
                try {
                    return LocalDate.parse(value);
                }
                catch (IllegalArgumentException e) {
                    ParserUtil.throwParseException(value, primitiveType, e);
                    break;
                }
            }
            case DATE_TIME_OFFSET: {
                try {
                    return ZonedDateTime.parse(value);
                }
                catch (IllegalArgumentException e) {
                    ParserUtil.throwParseException(value, primitiveType, e);
                    break;
                }
            }
            case DURATION: {
                try {
                    return Period.parse(value);
                }
                catch (IllegalArgumentException e) {
                    ParserUtil.throwParseException(value, primitiveType, e);
                    break;
                }
            }
            case TIME_OF_DAY: {
                try {
                    return LocalTime.parse(value);
                }
                catch (IllegalArgumentException e) {
                    ParserUtil.throwParseException(value, primitiveType, e);
                    break;
                }
            }
            case DECIMAL: {
                try {
                    return new BigDecimal(value);
                }
                catch (NumberFormatException e) {
                    ParserUtil.throwParseException(value, primitiveType, e);
                    break;
                }
            }
            case DOUBLE: {
                try {
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    ParserUtil.throwParseException(value, primitiveType, e);
                    break;
                }
            }
            case SINGLE: {
                try {
                    return Float.valueOf(Float.parseFloat(value));
                }
                catch (NumberFormatException e) {
                    ParserUtil.throwParseException(value, primitiveType, e);
                    break;
                }
            }
            case GUID: {
                try {
                    return UUID.fromString(value);
                }
                catch (IllegalArgumentException e) {
                    ParserUtil.throwParseException(value, primitiveType, e);
                    break;
                }
            }
            case INT16: {
                try {
                    return Short.valueOf(value);
                }
                catch (NumberFormatException e) {
                    ParserUtil.throwParseException(value, primitiveType, e);
                    break;
                }
            }
            case INT32: {
                try {
                    return Integer.valueOf(value);
                }
                catch (NumberFormatException e) {
                    ParserUtil.throwParseException(value, primitiveType, e);
                    break;
                }
            }
            case INT64: {
                try {
                    return Long.valueOf(value);
                }
                catch (NumberFormatException e) {
                    ParserUtil.throwParseException(value, primitiveType, e);
                    break;
                }
            }
            case STRING: {
                return value;
            }
            case SBYTE: {
                try {
                    return Byte.valueOf(value);
                }
                catch (NumberFormatException e) {
                    ParserUtil.throwParseException(value, primitiveType, e);
                    break;
                }
            }
            default: {
                throw new ODataNotImplementedException("Unsupported primitive type: " + primitiveType + " for value: " + value);
            }
        }
        return null;
    }

    private static void throwParseException(String value, Type type, Throwable cause) throws ODataUnmarshallingException {
        throw new ODataUnmarshallingException("This is not a valid " + type + " value: " + value, cause);
    }

    public static Object parseEnumValue(String value, EnumType enumType) throws ODataException {
        EnumMember member = enumType.getMember(value);
        if (member == null) {
            member = enumType.getMember(Long.valueOf(value));
        }
        if (member == null) {
            throw new ODataUnmarshallingException("Enum member not found in entity data model, type: " + enumType + " for value: " + value);
        }
        Class<?> javaType = enumType.getJavaType();
        try {
            return Enum.valueOf(javaType, member.getName());
        }
        catch (IllegalArgumentException e) {
            throw new ODataEdmException("Java enum type does not match what is registered in the entity data model", e);
        }
    }
}

